/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.config.Config;
import com.ericsson.ssa.config.ConfigFactory;
import com.ericsson.ssa.config.Constants;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.dns.TargetTuple;

import java.io.IOException;

import java.net.InetAddress;
import java.net.InetSocketAddress;

import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;


/**
 * @author ehsroha
 * @reveiwed ehsroha 2006-nov-14
 */
public class TCPListener extends LinkBase implements Link {
    private static final String TRANSPORT_TCP = "TCP";
    private Logger _log = (Logger) Logger.getLogger("SipContainer");
    private ServerSocketChannel _serverSocketChannel = null;
    private int _port = -1;
    private final boolean _acceptRegister;
    private Config _config = ConfigFactory.getConfig();

    public TCPListener(int port, OLDNetworkManager n, Layer l,
        boolean acceptRegister) {
        super(n, l);
        _port = port;
        _acceptRegister = acceptRegister;
    }

    private boolean isAcceptRegister() {
        return _acceptRegister;
    }

    public String getTransport() {
        return TRANSPORT_TCP;
    }

    public TargetTuple getTargetTuple() {
        return null;
    }

    public boolean isOpen() {
        return (_serverSocketChannel != null) ? _serverSocketChannel.isOpen()
                                              : false;
    }

    public void open() throws IOException {
        _serverSocketChannel = ServerSocketChannel.open();
        _serverSocketChannel.configureBlocking(false);

        InetAddress ia = InetAddress.getByName(_config.get(Constants.HOST));
        _serverSocketChannel.socket().bind(new InetSocketAddress(ia, _port));
        _serverSocketChannel.register(_networkManager.getSelector(),
            SelectionKey.OP_ACCEPT, this);

        // register with read event
        _networkManager.getSelector().wakeup();

        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "Opening " + ia + ":" + _port);
        }
    }

    protected void closeImpl() throws IOException {
        _serverSocketChannel.close();
    }

    public void run() {
        try {
            SocketChannel newChannel = _serverSocketChannel.accept();
            new TCPLink(newChannel, _networkManager, _nextLayer,
                isAcceptRegister());
        } catch (IOException ioe) {
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "", ioe);
            }
        }
    }

    public void dispatch(SipServletRequestImpl req) {
        // TODO Auto-generated method stub
    }

    public void dispatch(SipServletResponseImpl resp) {
        // TODO Auto-generated method stub
    }

    public InetSocketAddress getLocal() {
        return (InetSocketAddress) _serverSocketChannel.socket()
                                                       .getLocalSocketAddress();
    }

    /**
     * Returns always null
     *
     * @return always null
     */
    public InetSocketAddress getRemote() {
        return null;
    }

    public SelectableChannel getSelectableChannel() {
        return _serverSocketChannel;
    }

    public void write(InetSocketAddress remote, ByteBuffer buffer) {
        throw new UnsupportedOperationException(
            "Can't write to a TCP listener socket!");
    }

    public String getInfo() {
        return getClass().getName();
    }
}
