/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container.annotation;

import com.ericsson.ssa.sip.SipFactoryImpl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;


public class AnnotationHandler {
    private static Logger logger = Logger.getLogger("SipContainer");

    /**
     * Inject SIP annotations to an instance
     *
     * @param instance
     */
    public static void processSipAnnotation(Object instance) {
        Field[] fields = instance.getClass().getDeclaredFields();

        // Intropect all the fields in the servlet
        for (int i = 0; i < fields.length; i++) {
            Field field = fields[i];
            Annotation annotation = field.getAnnotation(javax.servlet.sip.annotation.SipFactory.class);

            if (annotation != null) {
                field.setAccessible(true);

                try {
                    field.set(instance, SipFactoryImpl.getInstance());
                } catch (IllegalArgumentException e) {
                    logger.log(Level.SEVERE,
                        "Failed to inject the SipFactory annotation", e);
                } catch (IllegalAccessException e) {
                    logger.log(Level.SEVERE,
                        "Failed to inject the SipFactory annotation", e);
                }
            }
        }
    }
}
