/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container.auth;

import com.ericsson.ssa.dd.ResourceCollection;
import com.ericsson.ssa.dd.SecurityConstraint;
import com.ericsson.ssa.dd.SecurityRole;
import com.ericsson.ssa.dd.SecurityRoleReference;
import com.ericsson.ssa.dd.Servlet;
import com.ericsson.ssa.dd.SipApplication;

import org.jvnet.glassfish.comms.security.authorize.SipResourcePermission;
import org.jvnet.glassfish.comms.security.authorize.SipRoleRefPermission;
import org.jvnet.glassfish.comms.security.authorize.SipRoleRefPermission;
import org.jvnet.glassfish.comms.security.authorize.SipUserDataPermission;
import org.jvnet.glassfish.comms.security.util.PolicyBuilder;

import java.security.Permissions;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import org.jvnet.glassfish.comms.security.authorize.SipResourcePermission;
import org.jvnet.glassfish.comms.security.authorize.SipRoleRefPermission;
import org.jvnet.glassfish.comms.security.util.PolicyBuilder;
import org.jvnet.glassfish.comms.security.authorize.SipUserDataPermission;


/**
 *
 * @author K.Venugopal@sun.com
 */
public class DescriptorProcessor {

    private PolicyConfiguration pc = null;
    private static String[] sipMethods = new String[] {
            "INVITE", "CANCEL", "REGISTER", "ACK", "OPTIONS", "INFO"
        };

    @SuppressWarnings(value = "unchecked")
    public void process(String sarBundleName, SipApplication sipConfig) {

        Collection<SecurityConstraint> constraints = sipConfig.getSecurityConstraints();
        PolicyBuilder util = new PolicyBuilder();

        HashMap reslist = new HashMap();
        HashMap roleList = new HashMap();

        String contextId = sipConfig.getAppName();
        if (contextId == null || contextId.length() == 0) {
            contextId = sarBundleName;
            if(contextId.length() > 0 && contextId.startsWith("/")){
                 contextId = contextId.substring(1);
            }
        }
        contextId = contextId + "/" + contextId;
        try {
            pc = (PolicyConfiguration) util.getInstance(contextId);
        } catch (PolicyContextException pce) {
            pce.printStackTrace();
        }

        if (constraints == null || constraints.size() == 0) {
            addDefaultPermissions(sipConfig);
            return;
        }
        Iterator<SecurityConstraint> itr = constraints.iterator();

        Key key = new Key();
        Map<String, SecurityRole> roleMap = sipConfig.getSecurityRoles();

        Map<String, TransportConstraints> userDataConsTable = new HashMap<String, TransportConstraints>();
        HashMap<String, Set> restrictedActionList = new HashMap<String, Set>();

        while (itr.hasNext()) {
            SecurityConstraint sc = itr.next();
            Collection<ResourceCollection> resources = sc.getResourceCollections();
            Collection<String> roles = sc.getAuthorizationConstraintRoleNames();
            String transportType = sc.getUserDataTransportGuarantee();
            Iterator resItr = resources.iterator();

            while (resItr.hasNext()) {
                ResourceCollection rc = (ResourceCollection) resItr.next();
                Collection snColl = rc.getServletNames();
                Collection smColl = rc.getSipMethods();
                Iterator snItr = snColl.iterator();
                Iterator smItr = smColl.iterator();

                Iterator roleItr = roles.iterator();
                ServletActions servletRoles = null;

                while (roleItr.hasNext()) {
                    String roleName = (String) roleItr.next();
                    if (roleMap != null && !roleMap.containsKey(roleName)) {

                        continue;
                    }

                    key.roleName = roleName;

                    while (snItr.hasNext()) {
                        String servletName = (String) snItr.next();
                        key.servletName = servletName;

                        if (!restrictedActionList.containsKey(servletName)) {
                            restrictedActionList.put(servletName,
                                new HashSet<String>());
                        }

                        ServletActions servletActions = null;
                        TransportConstraints tc = null;

                        if (transportType != null) {
                            if (userDataConsTable.containsKey(servletName)) {
                                tc = userDataConsTable.get(servletName);
                            } else {
                                tc = new TransportConstraints(servletName);
                                userDataConsTable.put(servletName, tc);
                            }

                            tc.setType(transportType);
                        }

                        if (reslist.containsKey(key)) {
                            servletActions = (ServletActions) reslist.get(key);
                        } else {
                            servletActions = new ServletActions(servletName);
                            reslist.put(new Key(key.servletName, key.roleName),
                                servletActions);
                        }

                        while (smItr.hasNext()) {
                            String smName = (String) smItr.next();
                            servletActions.setAction(smName);

                            Set<String> resActions = restrictedActionList.get(servletName);
                            resActions.add(smName);

                            if (tc != null) {
                                tc.setAction(smName);
                            }
                        }
                    }
                }
            }
        }

        Set resKeys = reslist.keySet();
        Iterator keyItr = resKeys.iterator();
        HashMap<String, Permissions> permCollection = new HashMap();

        try {


            while (keyItr.hasNext()) {


                key = (Key) keyItr.next();

                ServletActions sa = (DescriptorProcessor.ServletActions) reslist.get(key);
                SipResourcePermission srp = new SipResourcePermission(key.servletName,
                        sa.actions);
                Permissions p = null;

                if (permCollection.containsKey(key.roleName)) {
                    p = permCollection.get(key.roleName);
                } else {
                    p = new Permissions();
                    permCollection.put(key.roleName, p);
                }

                p.add(srp);
                pc.addToRole(key.roleName,
                    new SipRoleRefPermission(key.servletName, key.roleName));
            }

            Iterator<String> permItr = permCollection.keySet().iterator();

            while (permItr.hasNext()) {
                String role = permItr.next();
                Permissions perms = (Permissions) permCollection.get(role);
                pc.addToRole(role, perms);
            }

            Map<String, Servlet> servlets = sipConfig.getServlets();
            Iterator<Servlet> servletItr = servlets.values().iterator();

            while (servletItr.hasNext()) {
                Servlet servlet = servletItr.next();
                String servletName = servlet.getServletName();
                Collection<SecurityRoleReference> srRef = servlet.getSecurityRoleReferences();

                if (srRef != null) {
                    Iterator<SecurityRoleReference> srItr = srRef.iterator();

                    while (srItr.hasNext()) {
                        SecurityRoleReference srr = srItr.next();
                        String roleLink = srr.getRoleLink();
                        String roleName = srr.getRoleName();
                        SipRoleRefPermission srp = new SipRoleRefPermission(servletName,
                                roleName);
                        pc.addToRole(roleLink, srp);
                    }
                }
            }

            Permissions udcPermList = new Permissions();
            Iterator<TransportConstraints> tcItr = userDataConsTable.values()
                                                                    .iterator();

            while (tcItr.hasNext()) {
                TransportConstraints tcValue = tcItr.next();

                //String[] actions = tcValue.actions.toArray(new String[0]);
                SipUserDataPermission wdp = new SipUserDataPermission(tcValue.servletName,
                        tcValue.actions, tcValue.getType());
                //SipUserDataPermission(tcValue.servletName, actions, tcValue.getType());
                udcPermList.add(wdp);
            }


            Map<String, Servlet> servletList = sipConfig.getServlets();
            Iterator<String> sitr = servletList.keySet().iterator();

            while (sitr.hasNext()) {
                String sn = sitr.next();
//                if (restrictedActionList.containsKey(sn)) {
//                    continue;
//                }
                Set<String> ral = restrictedActionList.get(sn);
                Set<String> allowedActions = new HashSet<String>();

                if (ral == null) {
                    SipResourcePermission srp = new SipResourcePermission(sn, allowedActions);
                    udcPermList.add(srp);

                    continue;
                }
                Iterator<String> ralItr = ral.iterator();
                while(ralItr.hasNext()){                    
                    allowedActions.add(ralItr.next());
                }
                SipResourcePermission srp = new SipResourcePermission(true,sn, allowedActions);
                udcPermList.add(srp);
            }

            pc.addToUncheckedPolicy(udcPermList);
            pc.commit();
        } catch (PolicyContextException pce) {
            pce.printStackTrace();
        }

        sipConfig.getSecurityRoles();
    }

    private void addDefaultPermissions(SipApplication sipConfig) {
        try {
            Map<String, Servlet> servletList = sipConfig.getServlets();
            Iterator<String> sitr = servletList.keySet().iterator();
            Permissions udcPermList = new Permissions();
            Set<String> emptySet = new HashSet<String>();
            String transport = null;
            while (sitr.hasNext()) {
                String sn = sitr.next();
                udcPermList.add(new SipResourcePermission(sn, emptySet));
                udcPermList.add(new SipUserDataPermission(sn, emptySet, transport));
            }
            pc.addToUncheckedPolicy(udcPermList);
            pc.commit();
        } catch (PolicyContextException pce) {
            pce.printStackTrace();
        }
    }

    class Key {
        String servletName = null;
        String roleName = null;

        public Key() {
        }

        public Key(String servletName, String roleName) {
            this.servletName = servletName;
            this.roleName = roleName;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }

            Key key = (Key) obj;

            if (((servletName != null) && servletName.equals(key.servletName)) &&
                    ((roleName != null) && roleName.equals(key.roleName))) {
                return true;
            }

            return false;
        }

        @Override
        public int hashCode() {
            if ((servletName == null) && (roleName != null)) {
                return roleName.hashCode();
            }

            if ((roleName == null) && (servletName != null)) {
                return servletName.hashCode();
            }

            if ((servletName == null) && (roleName == null)) {
                return 0;
            }

            return servletName.hashCode() + roleName.hashCode();
        }

        public void reset() {
            servletName = null;
            roleName = null;
        }
    }

    class ServletActions {
        String servletName = "";
        Set<String> actions = new HashSet<String>();
        Set<String> roles = new HashSet<String>();

        public ServletActions(String servletName) {
            this.servletName = servletName;
        }

        public void setServletName(String sn) {
            this.servletName = sn;
        }

        @SuppressWarnings(value = "unchecked")
        public void setAction(String action) {
            actions.add(action);
        }

        public void setRole(String rn) {
            this.roles.add(rn);
        }
    }

    class TransportConstraints extends ServletActions {
        String transportType = null;

        public TransportConstraints(String servletName) {
            super(servletName);
        }

        public void setType(String type) {
            this.transportType = type;
        }

        public String getType() {
            return transportType;
        }
    }
}
