/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container.mbeans;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;

import javax.management.Attribute;


public class MBeanCollectionProxy implements InvocationHandler {
    private static final Logger m_Log = (Logger) Logger.getLogger(
            "SipContainer");

    /**
     * The MBeans this proxy dispatches the "set" invocations to
     */
    private List<Object> m_MBeanCollection = null;

    /**
     * Stored List of Attributes for this Proxy This is used for the getMethod()
     */
    private HashMap<String, Attribute> m_Attributes = new HashMap<String, Attribute>();

    public MBeanCollectionProxy(List<Object> mBeanCollection) {
        for (Iterator it = mBeanCollection.iterator(); it.hasNext();) {
            Object x = it.next();

            if (m_Log.isLoggable(Level.FINE)) {
                m_Log.log(Level.FINE,
                    "MBean in collection: " + x.getClass().getName());
            }
        }

        m_MBeanCollection = mBeanCollection;
    }

    /**
     * Static method to create the MBeanCollectionProxy
     *
     * @param masterMBean
     * @param mBeanCollection
     * @return
     */
    public static Object createProxy(List<Object> mBeanCollection) {
        Class[] newInterfaces = new Class[] {
                javax.management.modelmbean.ModelMBean.class
            };

        return Proxy.newProxyInstance(MBeanCollectionProxy.class.getClassLoader(),
            newInterfaces, new MBeanCollectionProxy(mBeanCollection));
    }

    /**
     *
     *
     *
     */
    public Object invoke(Object proxy, Method method, Object[] args)
        throws Throwable {
        try {
            String met = method.getName();

            if ("setAttribute".equals(method.getName())) {
                Attribute attribute = (Attribute) args[0];
                String paramName = attribute.getName();
                Object paramValue = attribute.getValue();
                Method mToCall = null;
                // Add the Attribute to the Attribute List in the Proxy
                m_Attributes.put(paramName, new Attribute(paramName, paramValue));

                // Set Attributes for all MBeans in the collection
                for (Iterator mbeans = m_MBeanCollection.iterator();
                        mbeans.hasNext();) {
                    Object element = (Object) mbeans.next();
                    String className = element.getClass().getName();

                    try {
                        String setterName = "set" + paramName;
                        mToCall = element.getClass()
                                         .getMethod(setterName,
                                paramValue.getClass());
                        mToCall.invoke(element, paramValue);

                        if (m_Log.isLoggable(Level.FINE)) {
                            m_Log.log(Level.FINE,
                                paramName + " = '" + paramValue +
                                "' was set in " + className + " instance");
                        }
                    } catch (Exception ignore) {
                        // final chance for a parameter whose name starts with lowercase
                        try {
                            String setterName = "set" +
                                paramName.substring(0, 1).toUpperCase() +
                                paramName.substring(1);
                            mToCall = element.getClass()
                                             .getMethod(setterName,
                                    paramValue.getClass());
                            mToCall.invoke(element, paramValue);

                            if (m_Log.isLoggable(Level.FINE)) {
                                m_Log.log(Level.FINE,
                                    paramName + " = '" + paramValue +
                                    "' was set in " + className + " instance");
                            }
                        } catch (Exception innerIgnore) {
                        }
                    }
                }

                return new String("setAttribute Performed");
            } else if ("getAttribute".equals(method.getName())) {
                String attribName = (String) args[0];
                Attribute attribValue = m_Attributes.get(attribName);

                return attribValue.getValue();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return new String("Test");
    }
}
