/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container.mbeans;

import com.ericsson.ssa.container.startup.NamingService;

import com.sun.org.apache.commons.modeler.Registry;

import java.io.InputStream;

import java.util.List;
import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;


public class MBeanUtil {
    private static MBeanUtil instance = new MBeanUtil();
    private static Logger logger = Logger.getLogger("SipContainer");
    private Registry registry = Registry.getRegistry(null, null);
    private MBeanServer server = registry.getMBeanServer();
    private ObjectName loaderMbeanName = null;
    private String jmxDefaultHost = "127.0.0.1";
    private int jmxDefaultPort = 1099;

    public MBeanUtil() {
    }

    public static MBeanUtil getInstance() {
        return instance;
    }

    public void createServer() {
        try {
            loaderMbeanName = new ObjectName("Sailfin:type=loader");
            registry = Registry.getRegistry(null, null);
            server = registry.getMBeanServer();
        } catch (Exception e) {
            logger.log(Level.SEVERE, "Failed creating MBeanServer ", e);
        }
    }

    public MBeanServer getServer() {
        if (server == null) {
            createServer();
        }

        return server;
    }

    public void registerMBean(Object mbean, String mbeanName) {
        try {
            ObjectName oname = new ObjectName(mbeanName);
            registry.registerComponent(mbean, oname, null);
        } catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    /**
     * Registers a collection of MBeans with the same attributes
     *
     * @param masterMBean
     * @param mBeanCollection
     * @param mbeanName
     */
    public void registerMBeanCollection(List mBeanCollection, String mbeanName) {
        try {
            ObjectName oname = new ObjectName(mbeanName);
            Object mBeanCollectionProxy = MBeanCollectionProxy.createProxy(mBeanCollection);
            registry.registerComponent(mBeanCollectionProxy, oname, null);
        } catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    public void startRemoteAdapter() {
        try {
            if (server == null) {
                createServer();
            }

            ObjectName namingName = ObjectName.getInstance(
                    "naming:type=rmiregistry");
            NamingService ns = new NamingService();
            ns.setPort(getJmxDefaultPort());
            server.registerMBean(ns, namingName);
            server.invoke(namingName, "start", null, null);

            int namingPort = ((Integer) server.getAttribute(namingName, "Port")).intValue();
            String jndiPath = "/jmxconnector";
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://" +
                    getJmxDefaultHost() + "/jndi/rmi://" + getJmxDefaultHost() +
                    ":" + getJmxDefaultPort() + jndiPath);
            logger.log(Level.INFO, "Service URL is " + url);

            // Create and start the RMIConnectorServer
            JMXConnectorServer connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url,
                    null, server);
            connectorServer.start();
        } catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    public void loadDescriptors(Class clazz, String descriptorFileName)
        throws Exception {
        InputStream is = clazz.getClassLoader()
                              .getResourceAsStream(descriptorFileName);

        if (is == null) {
            is = clazz.getResourceAsStream(descriptorFileName);
        }

        if (is != null) {
            registry.loadMetadata(is);
        }
    }

    public void loadDefaultDescriptors() throws Exception {
        InputStream is = MBeanUtil.class.getClassLoader()
                                        .getResourceAsStream("mbeans-descriptors.xml");

        if (is == null) {
            is = MBeanUtil.class.getResourceAsStream("mbeans-descriptors.xml");
        }

        if (is != null) {
            registry.loadMetadata(is);
        }
    }

    public void createMBean(String className, String name) {
        try {
            ObjectName oName = new ObjectName(name);
            server.createMBean(className, oName, loaderMbeanName);
        } catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    public String getJmxDefaultHost() {
        return jmxDefaultHost;
    }

    public void setJmxDefaultHost(String jmxDefaultHost) {
        this.jmxDefaultHost = jmxDefaultHost;
    }

    public int getJmxDefaultPort() {
        return jmxDefaultPort;
    }

    public void setJmxDefaultPort(int jmxDefaultPort) {
        this.jmxDefaultPort = jmxDefaultPort;
    }
}
