/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container.processor;


/**
 * This is a task to be processed in the {@link QueuedProcessor}.
 *
 * @author ejoelbi
 * @since 2006 nov 1
 * @reveiwed ehsroha 2006-nov-14
 */
public interface QueuedTask extends Runnable {
    /**
     * Checks if this task is in error state.
     *
     * @return a description of the error if the task is in error state;
     *         otherwise null.
     */
    String getError();

    /**
     * Disposes this task (done when it has been found to be in error)
     *
     * @param cause
     *        a string explaining the cause for doing the error action.
     */
    void doErrorAction(String cause);
}
