/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container.sim;

import com.ericsson.ssa.annotations.SipAnnotationDescriptor;
import com.ericsson.ssa.config.SipFactoryFacade;
import com.ericsson.ssa.container.auth.AuthModule;
import com.ericsson.ssa.dd.ServletMapping;
import com.ericsson.ssa.dd.SipApplication;
import com.ericsson.ssa.fm.FmEventSender;
import com.ericsson.ssa.sip.AddressImpl;
import com.ericsson.ssa.sip.DialogFragment;
import com.ericsson.ssa.sip.DialogSet;
import com.ericsson.ssa.sip.SessionManager;
import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipServletMessageImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipSessionBase;
import com.ericsson.ssa.sip.SipSessionDialogImpl;
import com.ericsson.ssa.sip.SipSessionManager;
import com.ericsson.ssa.sip.ThreadData;

import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.valves.ValveBase;

import org.apache.coyote.tomcat5.CoyoteRequestFacade;

import java.io.IOException;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;

import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSession;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationRouterInfo;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.URI;


public class ServletDispatcher extends ValveBase {
    private static Logger logger = Logger.getLogger("SipContainer");

    /**
     * The parsed sip.xml object model
     */
    SipApplication sipApplicationModel;
    private SipFactoryFacade m_sipFactory = null;
    private HashMap<String, Wrapper> wrappers = new HashMap<String, Wrapper>(5,
            0.75f);
    private AuthModule authModule = null;
    private SipSessionManager m_SipSessionManager = null;

    /**
     * Constructor.
     */
    public ServletDispatcher(SipSessionManager manager) {
        super();
        m_SipSessionManager = manager;
    }

    /**
     * @return Returns the sipApplicationModel.
     */
    public SipApplication getSipApplicationModel() {
        return sipApplicationModel;
    }

    /**
     * @param sipApplicationModel
     *            The sipApplicationModel to set.
     */
    public void setSipApplicationModel(SipApplication sipApplicationModel) {
        this.sipApplicationModel = sipApplicationModel;
    }

    /**
     * For HTTP the next valve is invoked
     */
    @Override
    public int invoke(org.apache.catalina.Request request,
        org.apache.catalina.Response response)
        throws IOException, ServletException {
        return INVOKE_NEXT;
    }

    public void postInvoke(org.apache.catalina.Request request,
        org.apache.catalina.Response response)
        throws IOException, ServletException {
        CoyoteRequestFacade coyoteRequest = (CoyoteRequestFacade) request.getRequest();
        HttpSession session = coyoteRequest.getSession(false);

        ThreadData threadData = SipServletMessageImpl.getThreadLocalData();

        if ((session != null) && (threadData != null) &&
                (threadData.getSipApplicationSessionImpl() != null)) {
            threadData.getSipApplicationSessionImpl().addSession(session);

            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE,
                    "Added a HttpSession (" + session.getId() +
                    ") to a SipApplicationSession " +
                    threadData.getSipApplicationSessionImpl().getId());
            }
        }
    }

    /**
     * Creates a Session and atach it to the Request.
     *
     * @param req
     *            Request
     * @param appSess
     *            Application Session
     * @param handlerName
     *            Servlet to handle the request
     * @param info
     *            Application Router info used to initiate the session
     */
    private void createSession(SipServletRequestImpl req,
        SipApplicationSessionImpl appSess, String handlerName,
        SipApplicationRouterInfo info) {
        SipSessionBase s = req.getSessionImpl();

        if (s == null) {
            // check if we are spiraling: look up early dialog
            String id = DialogFragment.createKey(req.getCallId(),
                    req.getFrom().getParameter(AddressImpl.TAG_PARAM));
            DialogSet existingDs = SessionManager.getInstance()
                                                 .getEarlyDialog(id);

            if (existingDs != null) {
                // spiraling indeed!
                req.setDialog(new DialogFragment(existingDs, true));
            } else {
                // not spiraling
                // creates a new sip session and dialog structure
                DialogSet ds = new DialogSet(req.getCallId(), req.getFrom());
                DialogFragment df = new DialogFragment(ds);
                req.setDialog(df);
            }
        }

        // creates a new sip session
        DialogFragment d = req.getDialog();
        s = m_SipSessionManager.createSipSession(d.getDialogSet(), req.getTo(),
                appSess, handlerName);

        // JSR 289
        //s.setRegion(info.getRegion());
        String subscriberURIStr = info.getSubscriberURI();
        URI subscriberURI = null;
        if (!("".equals(subscriberURIStr)) && subscriberURIStr != null) {
	        try {
	        	subscriberURI = m_sipFactory.createURI(subscriberURIStr);
	        } catch (ServletParseException e) {
	        	if (logger.isLoggable(Level.WARNING)){
	        		logger.warning(
	    				"Invalid subscriber URI specified in router info, using null: " + e);
	        	}
	        }
        }        
        s.setSubscriberURI(subscriberURI);
        
        req.setSession(s);
    }

    /**
     * This method checks the servlet mapping roles and call the service method
     * of the servlet (wrapper).
     *
     * @param request
     * @param application
     * @throws Exception
     */
    public void invoke(SipServletRequestImpl request,
            SipApplicationRouterInfo info) throws TooManyHopsException,
            Exception {

        //authentication based on login-config only for M1.  
        if (sipApplicationModel != null) {           
                if(authModule == null){
                    authModule = new AuthModule(sipApplicationModel,getContainer().getName());
                }         
        }

        SipApplicationSessionImpl as = null;
        List<String> servlets = findServlets(request);

        // Found servlet(s) in an application which can handle the request
        // (mapping roles),
        // but if empty WE DO NOT need to do anything here. AD will invoke
        // this method with next the application.
        if (!servlets.isEmpty()) {
            as = m_sipFactory.createApplicationSession(request);

            Iterator<String> i = servlets.iterator();

            while (i.hasNext()) {
                String servletToInvoke = i.next();

                // Setting a current servlet in the AS to be used as
                // DefaultHandler.
                
                boolean permissionGranted =authModule.hasResourcePermissions(request.getMethod(),servletToInvoke);
                //hasUserDatauthModule.hasUserDataPermissions(servletToInvoke, request.getMethod(), aPermissions always returns false;
                //commented out as we have a bug here.
                /*
                if (!authModule.hasUserDataPermissions(servletToInvoke, request.getMethod(), request.isSecure())) {
                    SipServletResponseImpl resp = ((com.ericsson.ssa.sip.SipServletRequestImpl) request).createTerminatingResponse(302);
                    URI uriValue = request.getRequestURI();
                    String uri = uriValue.toString();
                    if(!uri.contains("sips")){
                        uri = uri.replaceFirst("sip:", "sips:");
                    }
                    resp.setHeader("Contact", uri);
                    resp.popDispatcher().dispatch(resp);
                    return;
                }*/
                if (!permissionGranted) {
                    if ((request.getUserPrincipal() == null) &&
                            authModule.needsAuthentication(servletToInvoke,
                                request.getMethod())) {
                        authModule.authenticate(request, servletToInvoke);

                        if (request.getUserPrincipal() == null) {
                            return;
                        }

                        if (!authModule.checkServletConstraints(request,
                                    servletToInvoke)) {
                            return;
                        }
                    } else if (authModule.needsAuthentication(servletToInvoke,
                                request.getMethod())) {
                        if (!authModule.checkServletConstraints(request,
                                    servletToInvoke)) {
                            return;
                        }
                    }
                }

                ((SipServletMessageImpl) request).setAuthModule(authModule);

                as.setCurrentServlet(servletToInvoke);
                createSession(request, as, servletToInvoke, info);

                SipServletWrapper wrap = (SipServletWrapper) wrappers.get(servletToInvoke);
                doPreInvoke(request);
                // wrap.allocate().service(request, null);
                wrap.invokeServlet(request);
                doPostInvoke(request);

                // If the invoked Servlet has send a response/request
                // STOP of invoking any servlets then.
                if (request.hasSent()) {
                    return;
                }
            }
        }
    }

    /**
     * The method will check the deployment discriptors of the servlets and
     * initialize the corresponding wrappers.
     */
    public void initialize() {
        Map<String, com.ericsson.ssa.dd.Servlet> servlets = sipApplicationModel.getServlets();

        for (Iterator<String> it = servlets.keySet().iterator(); it.hasNext();) {
            String servletName = it.next();
            Wrapper wrapper = initializeWrapper(servletName);
            wrappers.put(servletName, wrapper);
            getContainer().addChild(wrapper);
        }

        Container host = getContainer().getParent();

        Valve[] valves = host.getPipeline().getValves();

        for (int i = 0; i < valves.length; i++) {
            Valve valve = valves[i];
            String valveInfo = valve.getInfo();

            if (ApplicationDispatcher.APPLICATION_DISPATCHER.equals(valveInfo)) {
                ((ApplicationDispatcher) valve).addServletDispatcher(getContainer()
                                                                         .getName(),
                    this);

                return;
            }
        }

        //TODO make the sip factory an input param to initialize
        SipAnnotationDescriptor sad = getAnnotationDescriptor();
        m_sipFactory.initKeyMethod(sad.getSipApplicationKeyMethod());
    }

    private SipAnnotationDescriptor getAnnotationDescriptor() {
        StandardContext context = (StandardContext) getContainer();

        // Find Deployment path for the application
        String deploymentPath = context.getDocBase() + "/WEB-INF/classes";

        ClassLoader cl = context.getLoader().getClassLoader();

        // Scan Annotations
        SipAnnotationDescriptor sad = new SipAnnotationDescriptor(cl,
                deploymentPath);
        sad.processAnnotations();

        return sad;
    }

    public void unInitialize() {
        Container host = getContainer().getParent();
        Valve[] valves = host.getPipeline().getValves();

        for (int i = 0; i < valves.length; i++) {
            Valve valve = valves[i];
            String valveInfo = valve.getInfo();

            if (ApplicationDispatcher.APPLICATION_DISPATCHER.equals(valveInfo)) {
                ((ApplicationDispatcher) valve).removeServletDispatcher(getContainer()
                                                                            .getName());

                return;
            }
        }
    }

    /**
     * Initializes the SipServlet Wrappers with servlet class, loader and parent
     *
     * @param servletName
     * @return
     */
    protected Wrapper initializeWrapper(String servletName) {
        Wrapper wrapper = new SipServletWrapper(m_sipFactory,
                sipApplicationModel.getServlet(servletName));

        StandardContext context = (StandardContext) getContainer();

        String[] instanceListeners = context.findInstanceListeners();

        for (int i = 0; i < instanceListeners.length; i++) {
            try {
                Class clazz = Class.forName(instanceListeners[i]);
                InstanceListener listener = (InstanceListener) clazz.newInstance();
                wrapper.addInstanceListener(listener);
            } catch (Throwable t) {
                logger.log(Level.SEVERE,
                    "Failed creating instance listener for Wrapper", t);
            }
        }

        wrapper.setServletClass(sipApplicationModel.getServlet(servletName)
                                                   .getServletClass());
        wrapper.setParent(container);

        return wrapper;
    }

    /**
     * Find all servlets that trigerring rules matches a particular request, and
     * keeping the order of the servlets in the sip.xml file.
     *
     * @param request
     *            The request
     * @return A <code>List</code> of servlet name to invoke
     */
    protected List<String> findServlets(SipServletRequest request) {
        // We should keep the ordering of the servlets as it is
        // in the sip.xml. Do not trust the ordering of the mapping
        // getServletMapping return a HashMap but getServlet return
        // a LinkedHashMap which support a insertion-ordering. So itertation
        // should be on the servlets, not on the mapping (SSA1.0 chap. 11.1).
        ArrayList<String> matchingServlets = new ArrayList<String>();
        Map<String, com.ericsson.ssa.dd.Servlet> servlets = sipApplicationModel.getServlets();
        Map<String, ServletMapping> mappings = sipApplicationModel.getServletMappings();
        Iterator<String> itr = servlets.keySet().iterator();

        while (itr.hasNext()) {
            String servletName = itr.next();
            ServletMapping mapping = mappings.get(servletName);

            if ((mapping != null) &&
                    mapping.getPattern().getTopCondition().evaluate(request)) {
                matchingServlets.add(servletName);
            }
        }

        return matchingServlets;
    }

    /**
     * Check if a given servlet name included within the same application. This
     * method will be called from the application session or more correct from
     * sip session setHandler() method.
     *
     * @param servletName
     * @return boolean if the servlet name included within the same application.
     */
    public boolean findServlet(String servletName) {
        Map<String, com.ericsson.ssa.dd.Servlet> servlets = sipApplicationModel.getServlets();

        return servlets.containsKey(servletName);
    }

    /**
     * Loads all the <code>SipServlet</code>s that have a <i>load-on-startup</i>
     * attribute greater or equal to 0. There is no guarantee on the load order
     * of servlets with equal <i>load-on-startup</i> values.
     */
    public void loadServletsMarkedOnStartup() {
        TreeSet<com.ericsson.ssa.dd.Servlet> set = new TreeSet<com.ericsson.ssa.dd.Servlet>(new ServletStartupOrderComparator());
        set.addAll(sipApplicationModel.getServlets().values());

        for (Iterator it = set.iterator(); it.hasNext();) {
            com.ericsson.ssa.dd.Servlet servlet = (com.ericsson.ssa.dd.Servlet) it.next();

            if (servlet.getLoadOnStartup() >= 0) {
                Wrapper wrapper = getWrapper(servlet.getServletName());

                try {
                    wrapper.allocate();
                } catch (ServletException e) {
                    // NOTE: load errors (including a servlet that throws
                    // UnavailableException from the init() method) are NOT
                    // fatal to application startup
                    logger.log(Level.SEVERE,
                        String.format(
                            "Servlet '%1$s' threw an exception during initialization.",
                            wrapper.getName()), StandardWrapper.getRootCause(e));

                    // Generate a servlet initialization failure notification.
                    Context context = (Context) container;
                    FmEventSender.servletInitializationFailed(context.getName(),
                        wrapper.getName(), e.getMessage());
                }
            }
        }
    }

    /**
     * The method map a wrapper for a servlet.
     *
     * @param servlet
     *            Name The name of the servlet.
     * @return A <code>Wrapper</code> associated with the servlet name.
     */
    protected Wrapper getWrapper(String servletName) {
        Wrapper wrapper = (Wrapper) wrappers.get(servletName);

        if (wrapper == null) {
            wrapper = initializeWrapper(servletName);
            wrappers.put(servletName, wrapper);
        }

        return wrapper;
    }

    /**
     * Add a wrapper to the map.
     *
     * @param ServletName
     * @param wrapper
     */
    public void addWrapper(String servletName, Wrapper wrapper) {
        wrappers.put(servletName, wrapper);
    }

    /**
     * The method allocate a servlet instance.
     *
     * @param handler
     * @return A <code>Servlet</code> associated with handler.
     */
    public Servlet getHandler(String handler) {
        Servlet servlet = null;
        Wrapper wrap = (Wrapper) wrappers.get(handler);

        if (wrap != null) {
            try {
                servlet = wrap.allocate();
            } catch (ServletException e) {
                logger.log(Level.SEVERE, "Error allocating Servlet " + handler,
                    e);
            }
        }

        return servlet;
    }

    /**
     * The method return a <code>SipFactoryFacade</code>.
     *
     * @return A <code>SipFacotryFacade</code>
     */
    public SipFactoryFacade getSipFactory() {
        return m_sipFactory;
    }

    /**
     * The method set a <code>SipFactoryFacade</code>.
     *
     * @param sipFactory
     *            A <code>SipFacotryFacade</code>.
     */
    public void setSipFactory(SipFactoryFacade sipFactory) {
        this.m_sipFactory = sipFactory;
    }

    /*
     * public void registerListener(String servletName, String servletClass,
     * Servlet instance) { if (instance instanceof TimerListener) {
     * m_sipFactory.getSipApplicationListeners().setTimerListener((TimerListener)
     * instance); } else if (instance instanceof SipApplicationSessionListener) {
     * m_sipFactory.getSipApplicationListeners().addSipApplicationSessionListener(
     * (SipApplicationSessionListener) instance); } else if (instance instanceof
     * SipSessionListener) {
     * m_sipFactory.getSipApplicationListeners().addSipSessionListener(
     * (SipSessionListener) instance); } else if (instance instanceof
     * SipErrorListener) {
     * m_sipFactory.getSipApplicationListeners().addSipErrorListener((SipErrorListener)
     * instance); } else if (instance instanceof SipSessionAttributeListener) {
     * m_sipFactory.getSipApplicationListeners().addSipSessionAttributeListener(
     * (SipSessionAttributeListener) instance); } }
     */
    public void doPreInvoke(SipServletRequest request) {
        StandardContext context = (StandardContext) getContainer();

        Object[] instances = context.getApplicationEventListeners();

        ServletRequestEvent event = null;

        if ((instances != null) && (instances.length > 0)) {
            event = new ServletRequestEvent(((StandardContext) container).getServletContext(),
                    request);

            // create pre-service event
            for (int i = 0; i < instances.length; i++) {
                if (instances[i] == null) {
                    continue;
                }

                if (!(instances[i] instanceof ServletRequestListener)) {
                    continue;
                }

                ServletRequestListener listener = (ServletRequestListener) instances[i];

                // START SJSAS 6329662
                context.fireContainerEvent("beforeRequestInitialized", listener);

                try {
                    listener.requestInitialized(event);
                } catch (Throwable t) {
                    logger.log(Level.SEVERE,
                        "Failed calling requestInitialized()", t);
                }
            }
        }
    }

    public void doPostInvoke(SipServletRequest request) {
        StandardContext context = (StandardContext) getContainer();

        Object[] instances = context.getApplicationEventListeners();

        ServletRequestEvent event = new ServletRequestEvent(context.getServletContext(),
                request);

        if ((instances != null) && (instances.length > 0)) {
            // create post-service event
            for (int i = 0; i < instances.length; i++) {
                if (instances[i] == null) {
                    continue;
                }

                if (!(instances[i] instanceof ServletRequestListener)) {
                    continue;
                }

                ServletRequestListener listener = (ServletRequestListener) instances[i];
                // START SJSAS 6329662
                context.fireContainerEvent("beforeRequestDestroyed", listener);

                // END SJSAS 6329662
                try {
                    listener.requestDestroyed(event);
                } catch (Throwable t) {
                    logger.log(Level.SEVERE,
                        "Failed calling requestDestroyed()", t);

                    // START SJSAS 6329662
                } finally {
                    context.fireContainerEvent("afterRequestDestroyed", listener);

                    // END SJSAS 6329662
                }
            }
        }
    }
}
/*
class SessionKeyTest {
        public static String getKey(SipServletRequest req) {
                SipURI to = (SipURI) req.getTo().getURI();
                return to.getUser();
        }

}*/
