/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container.startup;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;


public class NamingService implements NamingServiceMBean {
    private int port;
    private Remote registry;
    private boolean running;

    /**
     * Creates a new instance of NamingService with the default rmiregistry port
     * (1099).
     */
    public NamingService() {
        this(Registry.REGISTRY_PORT);
    }

    /**
     * Creates a new instance of NamingService with the specified port.
     */
    public NamingService(int port) {
        this.port = port;
    }

    /**
     * Sets the port on which rmiregistry listens for incoming connections.
     *
     * @see #getPort
     */
    public void setPort(int port) {
        this.port = port;
    }

    /**
     * Returns the port on which rmiregistry listens for incoming connections
     *
     * @see #setPort
     */
    public int getPort() {
        return port;
    }

    /**
     * Returns whether this MBean has been started and not yet stopped.
     *
     * @see #start
     */
    public boolean isRunning() {
        return running;
    }

    /**
     * Starts this MBean: rmiregistry can now accept incoming calls
     *
     * @see #stop
     * @see #isRunning
     */
    public void start() throws RemoteException {
        if (!isRunning()) {
            registry = LocateRegistry.createRegistry(getPort());
            running = true;
        }
    }

    /**
     * Stops this MBean: rmiregistry cannot accept anymore incoming calls
     *
     * @see #start
     */
    public void stop() throws NoSuchObjectException {
        if (isRunning()) {
            running = !UnicastRemoteObject.unexportObject(registry, true);
        }
    }
}
