/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container.startup;

import com.ericsson.ssa.container.NetworkManager;
import com.ericsson.ssa.container.OverloadManager;
import com.ericsson.ssa.container.mbeans.MBeanUtil;
import com.ericsson.ssa.sip.SessionManager;
import com.ericsson.ssa.sip.transaction.TransactionManager;

import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardService;

import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;


/**
 * Handles Performance management MBeans.
 *
 * @author lmcpepe
 * @since 2005-apr-3
 *
 * @author erafope
 * @reviewed ehswolm 2007-feb-23
 */
public class PerformanceMBeanListener implements LifecycleListener {
    private static boolean _isEnabled = false;
    Logger logger = Logger.getLogger("SipContainer");
    String sessionMBean = "EAS:type=PerformanceManagement,name=SessionManager";
    String transactionMBean = "EAS:type=PerformanceManagement,name=TransactionManager";
    String networkMBean = "EAS:type=PerformanceManagement,name=NetworkManager";
    String overloadMBean = "EAS:type=PerformanceManagement,name=OverloadManager";

    public static boolean isEnabled() {
        return _isEnabled;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Got event: " + event.getType());
        }

        if (event.getSource() instanceof StandardService &&
                "start".equals(event.getType())) {
            MBeanUtil mbeanUtil = MBeanUtil.getInstance();
            String JmxDescriptorFile = "/com/ericsson/ssa/container/mbeans/descriptors/performance-mbeans-descriptors.xml";

            try {
                String a = "";
                mbeanUtil.loadDescriptors(this.getClass(), JmxDescriptorFile);

                mbeanUtil.registerMBean(SessionManager.getInstance(),
                    sessionMBean);
                mbeanUtil.registerMBean(TransactionManager.getInstance(),
                    transactionMBean);
                mbeanUtil.registerMBean(NetworkManager.getInstance(),
                    networkMBean);
                mbeanUtil.registerMBean(OverloadManager.getInstance(),
                    overloadMBean);
                _isEnabled = true;

                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE,
                        "PerformanceMBean registered succesfully");
                }
            } catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot load MBean Descriptor File", e);
            }
        }
    }

    /**
     * Added for the benefit of unit testing. Non-test
     * code must not call this method.
     *
     */
    public static void setEnabled(boolean u) {
        _isEnabled = u;
    }
}
