/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.container.startup;


/**
 * This class contains configuration constants used in TmSpaMBean
 * <p>
 *
 *
 * The class is final merely to help compiler optimizations.
 * <p>
 *
 * @author erafope
 * @reviewed ehswolm 2007-feb-23
 */
final class TmSpaConfig {
    /** The name of the 'ApplicationDispatcherLoopInternal' attribute */
    static final String APPLICATION_DISPATCHER_LOOP_INTERNAL = "ApplicationDispatcherLoopInternal";

    /** The default value for the 'ApplicationDispatcherLoopInternal' attribute */
    static final Boolean APPLICATION_DISPATCHER_LOOP_INTERNAL_DEF = Boolean.TRUE;

    /** The name of the 'defaultTCPTransport' attribute */
    static final String DEFAULT_TCP_TRANSPORT = "defaultTCPTransport";

    /** The default value for the 'defaultTCPTransport' attribute */
    static final Boolean DEFAULT_TCP_TRANSPORT_DEF = Boolean.FALSE;

    /** The name of the 'DnsCacheSize' attribute */
    static final String DNS_CACHE_SIZE = "DnsCacheSize";

    /** The default value for the 'DnsCacheSize' attribute */
    static final Integer DNS_CACHE_SIZE_DEF = new Integer(20000);

    /** The name of the 'DnsServerList' attribute */
    static final String DNS_SERVER_LIST = "DnsServerList";

    /** The name of the 'EAS503Disabled' attribute */
    static final String EAS_503_DISABLED = "Eas503Disabled";

    /** The default value for the 'EAS503Disabled' attribute */
    static final Boolean EAS_503_DISABLED_DEF = Boolean.FALSE;

    /** The name of the 'EnumTopDomain' attribute */
    static final String ENUM_TOP_DOMAIN = "EnumTopDomain";

    /** The default value for the 'EnumTopDomain' attribute */
    static final String ENUM_TOP_DOMAIN_DEF = "e164.arpa";

    /** The name of the 'ErrorResponseEnabled' attribute */
    static final String ERROR_RESPONSE_ENABLED = "ErrorResponseEnabled";

    /** The default value for the 'ErrorResponseEnabled' attribute */
    static final Boolean ERROR_RESPONSE_ENABLED_DEF = Boolean.FALSE;

    /** The name of the 'HttpThreshold' attribute */
    static final String HTTP_THRESHOLD = "HttpThreshold";

    /** The default value for the 'HttpThreshold' attribute */
    static final Integer HTTP_THRESHOLD_DEF = new Integer(70);

    /** The minimum allowed value for the 'HttpThreshold' attribute */
    static final Integer HTTP_THRESHOLD_MIN = new Integer(0);

    /** The maximum allowed value for the 'HttpThreshold' attribute */
    static final Integer HTTP_THRESHOLD_MAX = new Integer(100);

    /** The name of the 'IrThreshold' attribute */
    static final String IR_THRESHOLD = "IrThreshold";

    /** The default value for the 'IrThreshold' attribute */
    static final Integer IR_THRESHOLD_DEF = new Integer(70);

    /** The minimum allowed value for the 'IrThreshold' attribute */
    static final Integer IR_THRESHOLD_MIN = new Integer(0);

    /** The maximum allowed value for the 'IrThreshold' attribute */
    static final Integer IR_THRESHOLD_MAX = new Integer(100);

    /** The name of the 'JmxDefaultPort' attribute */
    static final String JMX_DEFAULT_PORT = "JmxDefaultPort";

    /** The default value for the 'JmxDefaultPort' attribute */
    static final Integer JMX_DEFAULT_PORT_DEF = new Integer(1099);

    /** The minimum allowed value for the 'JmxDefaultPort' attribute */
    static final Integer JMX_DEFAULT_PORT_MIN = new Integer(1025);

    /** The maximum allowed value for the 'JmxDefaultPort' attribute */
    static final Integer JMX_DEFAULT_PORT_MAX = new Integer(65535);

    /** The name of the 'MmThreshold' attribute */
    static final String MM_THRESHOLD = "MmThreshold";

    /** The default value for the 'MmThreshold' attribute */
    static final Integer MM_THRESHOLD_DEF = new Integer(99);

    /** The minimum allowed value for the 'MmThreshold' attribute */
    static final Integer MM_THRESHOLD_MIN = new Integer(0);

    /** The maximum allowed value for the 'MmThreshold' attribute */
    static final Integer MM_THRESHOLD_MAX = new Integer(100);

    /** The name of the 'NumberOfSamples' attribute */
    static final String NUMBER_OF_SAMPLES = "NumberOfSamples";

    /** The default value for the 'NumberOfSamples' attribute */
    static final Integer NUMBER_OF_SAMPLES_DEF = new Integer(2);

    /** The minimum allowed value for the 'NumberOfSamples' attribute */
    static final Integer NUMBER_OF_SAMPLES_MIN = new Integer(2);

    /** The minimum allowed value for the 'NumberOfSamples' attribute */
    static final Integer NUMBER_OF_SAMPLES_MAX = new Integer(20);

    /** The name of the 'OverloadRegulation' attribute */
    static final String OVERLOAD_REGULATION = "OverloadRegulation";

    /** The default value for the 'OverloadRegulation' attribute */
    static final Boolean OVERLOAD_REGULATION_DEF = Boolean.FALSE;

    /** The name of the 'ProxyConnectionTimeout' attribute */
    static final String PROXY_CONNECTION_TIMEOUT = "ProxyConnectionTimeout";

    /** The default value for the 'ProxyConnectionTimeout' attribute */
    static final Integer PROXY_CONNECTION_TIMEOUT_DEF = new Integer(0);

    /** The minimum allowed value for the 'ProxyConnectionTimeout' attribute */
    static final Integer PROXY_CONNECTION_TIMEOUT_MIN = new Integer(0);

    /** The name of the 'ProxyPoolSize' attribute */
    static final String PROXY_POOL_SIZE = "ProxyPoolSize";

    /** The default value for the 'ProxyPoolSize' attribute */
    static final Integer PROXY_POOL_SIZE_DEF = new Integer(2);

    /** The minimum allowed value for the 'ProxyPoolSize' attribute */
    static final Integer PROXY_POOL_SIZE_MIN = new Integer(1);

    /** The name of the 'ProxyRetries' attribute */
    static final String PROXY_RETRIES = "ProxyRetries";

    /** The default value for the 'ProxyRetries' attribute */
    static final Integer PROXY_RETRIES_DEF = new Integer(1);

    /** The minimum allowed value for the 'ProxyRetries' attribute */
    static final Integer PROXY_RETRIES_MIN = new Integer(0);

    /** The name of the 'ProxySocketTimeout' attribute */
    static final String PROXY_SOCKET_TIMEOUT = "ProxySocketTimeout";

    /** The default value for the 'ProxySocketTimeout' attribute */
    static final Integer PROXY_SOCKET_TIMEOUT_DEF = new Integer(120000);

    /** The minimum allowed value for the 'ProxySocketTimeout' attribute */
    static final Integer PROXY_SOCKET_TIMEOUT_MIN = new Integer(0);

    /** The name of the 'SampleRate' attribute */
    static final String SAMPLE_RATE = "SampleRate";

    /** The default value for the 'SampleRate' attribute */
    static final Integer SAMPLE_RATE_DEF = new Integer(2);

    /** The minimum allowed value for the 'SampleRate' attribute */
    static final Integer SAMPLE_RATE_MIN = new Integer(1);

    /** The maximum allowed value for the 'SampleRate' attribute */
    static final Integer SAMPLE_RATE_MAX = new Integer(120);

    /** The name of the 'SipLinkTimeout' attribute */
    static final String SIP_LINK_TIMEOUT = "SipLinkTimeout";

    /** The default value for the 'SipLinkTimeout' attribute */
    static final Integer SIP_LINK_TIMEOUT_DEF = new Integer(10);

    /** The name of the 'SipLinkTimeoutRetries' attribute */
    static final String SIP_LINK_TIMEOUT_RETRIES = "SipLinkTimeoutRetries";

    /** The default value for the 'SipLinkTimeoutRetries' attribute */
    static final Integer SIP_LINK_TIMEOUT_RETRIES_DEF = new Integer(25);

    /** The name of the 'SipLinkMaxThreadQueueLength' attribute */
    static final String SIP_LINK_MAX_QUEUE_LENGTH = "SipLinkMaxThreadQueueLength";

    /** The default value for the 'SipLinkMaxThreadQueueLength' attribute */
    static final Integer SIP_LINK_MAX_QUEUE_LENGTH_DEF = new Integer(0);

    /** The name of the 'SipLinkAliveTimeout' attribute */
    static final String SIP_LINK_ALIVE_TIMEOUT = "SipLinkAliveTimeout";

    /** The default value for the 'SipLinkAliveTimeout' attribute */
    static final Integer SIP_LINK_ALIVE_TIMEOUT_DEF = new Integer(120);

    /** The name of the 'SrThreshold' attribute */
    static final String SR_THRESHOLD = "SrThreshold";

    /** The default value for the 'SrThreshold' attribute */
    static final Integer SR_THRESHOLD_DEF = new Integer(80);

    /** The minimum allowed value for the 'SrThreshold' attribute */
    static final Integer SR_THRESHOLD_MIN = new Integer(0);

    /** The maximum allowed value for the 'SrThreshold' attribute */
    static final Integer SR_THRESHOLD_MAX = new Integer(100);

    /** The name of the 'ThreadPoolSize' attribute */
    static final String THREAD_POOL_SIZE = "ThreadPoolSize";

    /** The default value for the 'ThreadPoolSize' attribute */
    static final Integer THREAD_POOL_SIZE_DEF = new Integer(10);

    /** The minimum allowed value for the 'ThreadPoolSize' attribute */
    static final Integer THREAD_POOL_SIZE_MIN = new Integer(10);

    /** The maximum allowed value for the 'ThreadPoolSize' attribute */
    static final Integer THREAD_POOL_SIZE_MAX = new Integer(1000);

    /** The name of the 'timerT1' attribute */
    static final String TIMER_T1 = "timerT1";

    /** The default value for the 'timerT1' attribute */
    static final Integer TIMER_T1_DEF = new Integer(500);

    /** The name of the 'timerT2' attribute */
    static final String TIMER_T2 = "timerT2";

    /** The default value for the 'timerT2' attribute */
    static final Integer TIMER_T2_DEF = new Integer(4000);

    /** The name of the 'timerT4' attribute */
    static final String TIMER_T4 = "timerT4";

    /** The default value for the 'timerT4' attribute */
    static final Integer TIMER_T4_DEF = new Integer(5000);
}
