/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.dd;

import java.io.Serializable;


/**
 * Corresponds to the ejb-local-ref element.
 * <p>
 * This element is used for the declaration of a reference to an enterprise
 * bean's local home. The declaration consists of: <br> - an optional
 * description <br> - the EJB reference name used in the code of THE_COMPONENT
 * that's referencing the enterprise bean <br> - the expected type of the
 * referenced enterprise bean <br> - the expected local home and local
 * interfaces of the referenced enterprise bean <br> - optional ejb-link
 * information, used to specify the referenced enterprise bean
 *
 * @author qdesmar
 * @since 4-Dec-2003 (EAS 3.0)
 */
public class EjbLocalReference implements Serializable {
    private static final long serialVersionUID = 3257854263907662137L;
    private String description;
    private String name;
    private String type;
    private String localHome;
    private String local;
    private String ejbLink;

    /**
     * @return
     */
    public String getDescription() {
        return description;
    }

    /**
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * @return
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return
     */
    public String getType() {
        return type;
    }

    /**
     * @param type
     */
    public void setType(String type) {
        if (!EjbReferenceType.contains(type)) {
            throw new RuntimeException("Ejb reference type must be of " +
                EjbReferenceType.printNames());
        }

        this.type = type;
    }

    /**
     * @return
     */
    public String getLocalHome() {
        return localHome;
    }

    /**
     * @param localHome
     */
    public void setLocalHome(String localHome) {
        this.localHome = localHome;
    }

    /**
     * @return
     */
    public String getLocal() {
        return local;
    }

    /**
     * @param local
     */
    public void setLocal(String local) {
        this.local = local;
    }

    /**
     * @return
     */
    public String getEjbLink() {
        return ejbLink;
    }

    /**
     * @param ejbLink
     */
    public void setEjbLink(String ejbLink) {
        this.ejbLink = ejbLink;
    }
}
