/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.dd;

import java.util.Collection;
import java.util.HashMap;


public abstract class Enum {
    private static HashMap enumClasses = new HashMap(10);
    private String name;

    protected Enum(String name) {
        if ((name == null) || (name.length() == 0)) {
            throw new IllegalArgumentException("Invalid enum name: " + name);
        }

        Entry entry = getEntry(getClass());

        if (entry == null) {
            entry = new Entry();
            enumClasses.put(getClass(), entry);
        }

        if (entry.enumValues.containsKey(name)) {
            throw new IllegalArgumentException("Enum already exists for " +
                getClass().getName() + " and name " + name);
        }

        this.name = name;
        entry.enumValues.put(name, this);
    }

    public String getName() {
        return name;
    }

    protected static String[] getNames(Class class_) {
        Entry entry = (Entry) enumClasses.get(class_);
        assertEntryNotNull(entry, class_);

        return (String[]) entry.enumValues.keySet()
                                          .toArray(new String[entry.enumValues.size()]);
    }

    protected static boolean contains(Class class_, String name) {
        Entry entry = getEntry(class_);
        assertEntryNotNull(entry, class_);

        return entry.enumValues.containsKey(name);
    }

    protected static Entry getEntry(Class class_) {
        return (Entry) enumClasses.get(class_);
    }

    protected static String toString(Class class_) {
        String[] names = getNames(class_);
        StringBuffer buffer = new StringBuffer("[");

        for (int i = 0; i != names.length; ++i) {
            buffer.append(names[i]);

            if (i != (names.length - 1)) {
                buffer.append(", ");
            }
        }

        buffer.append("]");

        return buffer.toString();
    }

    protected static Collection getEnumList(Class class_) {
        Entry entry = getEntry(class_);
        assertEntryNotNull(entry, class_);

        return entry.enumValues.values();
    }

    protected static Collection getEnumNameList(Class class_) {
        Entry entry = getEntry(class_);
        assertEntryNotNull(entry, class_);

        return entry.enumValues.keySet();
    }

    private static void assertEntryNotNull(Entry entry, Class class_) {
        if (entry == null) {
            throw new IllegalArgumentException("No Enum exists for type " +
                class_.getName());
        }
    }

    private static class Entry {
        HashMap enumValues = new HashMap(10);
    }
}
