/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.dd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;


/**
 * Operator. The Operator abstract provide common services for the operators:
 * and, or, not
 */
public abstract class Operator implements Condition {
    protected List<Condition> subConditions;

    /**
     * @param condition
     */
    public void addCondition(Condition condition) {
        if (subConditions == null) {
            subConditions = new ArrayList<Condition>();
        }

        subConditions.add(condition);
    }

    /**
     * Get all subconditions of the operator
     *
     * @return The subsconditions of the operator
     */
    public Iterator<Condition> getSubConditions() {
        Iterator<Condition> itr = null;

        if (subConditions == null) {
            itr = Collections.EMPTY_LIST.iterator();
        } else {
            itr = subConditions.iterator();
        }

        return itr;
    }

    /**
     * @param sourceList
     * @param destinationList
     * @throws SipParserException
     */
    protected void addOnlyNewElementToTheList(ArrayList<String> sourceList,
        ArrayList<String> destinationList) throws SipParserException {
        if ((destinationList == null) || (sourceList == null)) {
            throw new SipParserException("AND: impossible Condition: " +
                "addOnlyNewElementToTheList empty List or null");
        }

        if (destinationList.contains(SessionCase.EXTERNAL.toString())) {
            return;
        }

        if (sourceList.contains(SessionCase.EXTERNAL.toString())) {
            destinationList.clear();
            destinationList.add(SessionCase.EXTERNAL.toString());

            return;
        }

        Iterator<String> sourceListIter = sourceList.iterator();
        String element = null;

        while (sourceListIter.hasNext()) {
            element = sourceListIter.next();

            if (!destinationList.contains(element)) {
                destinationList.add(element);
            }
        }
    }
}
