/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.dd;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;


public class Servlet implements Serializable {
    private static final long serialVersionUID = 3258412845946254135L;
    private String smallIcon;
    private String largeIcon;
    private String servletName;
    private String displayName;
    private String description;
    private String servletClass;
    private Map<String, Parameter> initParameters;
    private int loadOnStartup;
    private String runAsDescription;
    private String runAsRoleName;
    private Collection<SecurityRoleReference> securityRoleReferences;

    /**
     * Default constructor.
     */
    public Servlet() {
    }

    /**
     * @param parameter
     */
    public void addInitParameter(Parameter parameter) {
        if (initParameters == null) {
            initParameters = new HashMap<String, Parameter>();
        }

        if (initParameters.get(parameter.getName()) != null) {
            throw new RuntimeException("Each parameter name must be unique " +
                "in the initialization parameter");
        }

        initParameters.put(parameter.getName(), parameter);
    }

    /**
     * @param securityRoleReference
     */
    public void addSecurityRoleReference(
        SecurityRoleReference securityRoleReference) {
        if (securityRoleReferences == null) {
            securityRoleReferences = new ArrayList<SecurityRoleReference>();
        }

        securityRoleReferences.add(securityRoleReference);
    }

    /**
     * @return
     */
    public Map getInitParameters() {
        return initParameters;
    }

    /**
     * @param initParameterName
     * @return
     */
    public Parameter getInitParameter(String initParameterName) {
        return (Parameter) initParameters.get(initParameterName);
    }

    /**
     * @return
     */
    public Collection<SecurityRoleReference> getSecurityRoleReferences() {
        return securityRoleReferences;
    }

    /**
     * @return
     */
    public String getSmallIcon() {
        return smallIcon;
    }

    /**
     * @param smallIcon
     */
    public void setSmallIcon(String smallIcon) {
        this.smallIcon = smallIcon;
    }

    /**
     * @return
     */
    public String getLargeIcon() {
        return largeIcon;
    }

    /**
     * @param largeIcon
     */
    public void setLargeIcon(String largeIcon) {
        this.largeIcon = largeIcon;
    }

    /**
     * @return
     */
    public String getServletName() {
        return servletName;
    }

    /**
     * @param servletName
     */
    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    /**
     * @return
     */
    public String getDisplayName() {
        return displayName;
    }

    /**
     * @param displayName
     */
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    /**
     * @return
     */
    public String getDescription() {
        return description;
    }

    /**
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * @return
     */
    public String getServletClass() {
        return servletClass;
    }

    /**
     * @param servletClass
     */
    public void setServletClass(String servletClass) {
        this.servletClass = servletClass;
    }

    /**
     * @return
     */
    public int getLoadOnStartup() {
        return loadOnStartup;
    }

    /**
     * @param loadOnStartup
     */
    public void setLoadOnStartup(int loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    /**
     * This method will be called by the digester.
     * @param loadOnStartup
     */
    public void setLoadOnStartup(String loadOnStartup) {
        // This method will fix the problem when the app. developer
        // write <load-on-startup/> with on tag. The digester will
        // this method with an empty String.
        if (!loadOnStartup.equals("")) {
            this.loadOnStartup = Integer.valueOf(loadOnStartup);
        }
    }

    /**
     * @return
     */
    public String getRunAsDescription() {
        return runAsDescription;
    }

    /**
     * @param runAsDescription
     */
    public void setRunAsDescription(String runAsDescription) {
        this.runAsDescription = runAsDescription;
    }

    /**
     * @return
     */
    public String getRunAsRoleName() {
        return runAsRoleName;
    }

    /**
     * @param runAsRoleName
     */
    public void setRunAsRoleName(String runAsRoleName) {
        this.runAsRoleName = runAsRoleName;
    }
}
