/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.dd;

import com.ericsson.ssa.dd.rules.SetOperand;
import com.ericsson.ssa.dd.rules.SetOperator;

import com.sun.org.apache.commons.digester.Digester;
import com.sun.org.apache.commons.digester.RuleSetBase;


/**
 * @author lmcpepe
 */
public class SipDeploymentDescriptorRuleSet extends RuleSetBase {
    // ----------------------------------------------------- Instance Variables
    /**
     * The matching pattern prefix to use for recognizing our elements.
     */
    protected String prefix = null;

    // ------------------------------------------------------------ Constructor
    /**
     * Construct an instance of this <code>RuleSet</code> with the default
     * matching pattern prefix.
     */
    public SipDeploymentDescriptorRuleSet() {
        this("");
    }

    /**
     * Construct an instance of this <code>RuleSet</code> with the specified
     * matching pattern prefix.
     *
     * @param prefix
     *        Prefix for matching pattern rules (including the trailing slash
     *        character)
     */
    public SipDeploymentDescriptorRuleSet(String prefix) {
        super();
        this.namespaceURI = null;
        this.prefix = prefix;
    }

    /**
     * <p>
     * Add the set of Rule instances defined in this RuleSet to the specified
     * <code>Digester</code> instance, associating them with our namespace URI
     * (if any). This method should only be called by a Digester instance.
     * </p>
     *
     * @param digester
     *        Digester instance to which the new Rule instances should be added.
     */
    public void addRuleInstances(Digester digester) {
        /*
         * <pattern value="sip-app"> <call-method-rule pattern="display-name"
         * methodname="setDisplayName" paramcount="0" /> <call-method-rule
         * pattern="description" methodname="setDescription" paramcount="0" />
         * <call-method-rule pattern="distributable"
         * methodname="setDistributable"/> </pattern> <pattern
         * value="sip-app/icon"> <call-method-rule pattern="small-icon"
         * methodname="setSmallIcon" paramcount="0" /> <call-method-rule
         * pattern="large-icon" methodname="setLargeIcon" paramcount="0" />
         * </pattern>
         */
        digester.addObjectCreate("sip-app", SipApplication.class.getName(),
            "className");
        digester.addCallMethod("sip-app/display-name", "setDisplayName", 0);
        digester.addCallMethod("sip-app/description", "setDescription", 0);
        digester.addCallMethod("sip-app/distributable", "setDistributable");
        digester.addCallMethod("sip-app/app-name", "setAppName", 0);
        digester.addObjectCreate("sip-app/security-role",
            SecurityRole.class.getName(), "className");
        digester.addCallMethod("sip-app/security-role/description",
            "setDescription", 0);
        digester.addCallMethod("sip-app/security-role/role-name", "setName", 0);
        digester.addSetNext("sip-app/security-role", "addSecurityRole",
            SecurityRole.class.getName());

        /* <!-- session-config -->
        * <pattern value="sip-app/session-config"> <call-method-rule
        * pattern="session-timeout" methodname="setSessionConfigTimeout"
        * paramcount="0" paramtypes="java.lang.Long" /> </pattern>
        */
        digester.addCallMethod("sip-app/session-config/session-timeout",
            "setSessionConfigTimeout", 0);
        /* <!-- proxy-config -->
         * <pattern value="sip-app/proxy-config">
         * <call-method-rule pattern="sequential-search-timeout"
         * methodname="setProxyConfigSequentialSearchTimeout" paramcount="0"
         * paramtypes="java.lang.Long" /> </pattern>
         */
        digester.addCallMethod("sip-app/proxy-config/sequential-search-timeout",
            "setProxyConfigSequentialSearchTimeout", 0);
        /*
         * <pattern value="sip-app/context-param"> <object-create-rule
         * classname="com.ericsson.ssa.dd.Parameter" /> <call-method-rule
         * pattern="param-name" methodname="setName" paramcount="0" />
         * <call-method-rule pattern="param-value" methodname="setValue"
         * paramcount="0" /> <call-method-rule pattern="description"
         * methodname="setDescription" paramcount="0" /> <set-next-rule
         * methodname="addContextParameter" /> </pattern>
         */
        digester.addObjectCreate("sip-app/context-param",
            Parameter.class.getName(), "className");
        digester.addCallMethod("sip-app/context-param/param-name", "setName", 0);
        digester.addCallMethod("sip-app/context-param/param-value", "setValue",
            0);
        digester.addCallMethod("sip-app/context-param/description",
            "setDescription", 0);
        digester.addSetNext("sip-app/context-param", "addContextParameter",
            Parameter.class.getName());
        digester.addCallMethod("sip-app/listener/listener-class",
            "addListener", 0);
        // TODO Add Listener
        /*
         * <pattern value="sip-app/listener/listener-class"> <call-method-rule
         * methodname="addListener" paramcount="0" /> </pattern>
         */

        /*
         * <!-- servlet --> <pattern value="sip-app/servlet"> <object-create-rule
         * classname="com.ericsson.ssa.dd.Servlet" /> <call-method-rule
         * pattern="servlet-name" methodname="setServletName" paramcount="0" />
         * <call-method-rule pattern="display-name" methodname="setDisplayName"
         * paramcount="0" /> <call-method-rule pattern="description"
         * methodname="setDescription" paramcount="0" /> <call-method-rule
         * pattern="servlet-class" methodname="setServletClass" paramcount="0" />
         * <call-method-rule pattern="load-on-startup"
         * methodname="setLoadOnStartup" paramcount="0"
         * paramtypes="java.lang.Integer" /> <set-next-rule
         * methodname="addServlet" /> </pattern>
         */
        digester.addObjectCreate("sip-app/servlet", Servlet.class.getName(),
            "className");
        digester.addCallMethod("sip-app/servlet/servlet-name",
            "setServletName", 0);
        digester.addCallMethod("sip-app/servlet/display-name",
            "setDisplayName", 0);
        digester.addCallMethod("sip-app/servlet/description", "setDescription",
            0);
        digester.addCallMethod("sip-app/servlet/servlet-class",
            "setServletClass", 0);
        digester.addCallMethod("sip-app/servlet/load-on-startup",
            "setLoadOnStartup", 0);
        digester.addObjectCreate("sip-app/servlet/security-role-ref",
            SecurityRoleReference.class.getName(), "className");
        digester.addCallMethod("sip-app/servlet/security-role-ref/description",
            "setDescription", 0);
        digester.addCallMethod("sip-app/servlet/security-role-ref/role-name",
            "setRoleName", 0);
        digester.addCallMethod("sip-app/servlet/security-role-ref/role-link",
            "setRoleLink", 0);
        digester.addSetNext("sip-app/servlet/security-role-ref",
            "addSecurityRoleReference", SecurityRoleReference.class.getName());

        digester.addObjectCreate("sip-app/servlet/init-param",
            Parameter.class.getName(), "className");
        digester.addCallMethod("sip-app/servlet/init-param/param-name",
            "setName", 0);
        digester.addCallMethod("sip-app/servlet/init-param/param-value",
            "setValue", 0);
        digester.addSetNext("sip-app/servlet/init-param", "addInitParameter",
            Parameter.class.getName());

        digester.addSetNext("sip-app/servlet", "addServlet",
            Servlet.class.getName());
        /*
         * <pattern value="sip-app/servlet/icon"> <call-method-rule
         * pattern="small-icon" methodname="setSmallIcon" paramcount="0" />
         * <call-method-rule pattern="large-icon" methodname="setLargeIcon"
         * paramcount="0" /> </pattern> <pattern
         * value="sip-app/servlet/init-param"> <object-create-rule
         * classname="com.ericsson.ssa.dd.Parameter" /> <call-method-rule
         * pattern="param-name" methodname="setName" paramcount="0" />
         * <call-method-rule pattern="param-value" methodname="setValue"
         * paramcount="0" /> <call-method-rule pattern="description"
         * methodname="setDescription" paramcount="0" /> <set-next-rule
         * methodname="addInitParameter" /> </pattern> <pattern
         * value="sip-app/servlet/run-as"> <call-method-rule pattern="description"
         * methodname="setRunAsDescription" paramcount="0" /> <call-method-rule
         * pattern="role-name" methodname="setRunAsRoleName" paramcount="0" />
         * </pattern> <pattern value="sip-app/servlet/security-role-ref">
         * <object-create-rule
         * classname="com.ericsson.ssa.dd.SecurityRoleReference" />
         * <call-method-rule pattern="description" methodname="setDescription"
         * paramcount="0" /> <call-method-rule pattern="role-name"
         * methodname="setRoleName" paramcount="0" /> <call-method-rule
         * pattern="role-link" methodname="setRoleLink" paramcount="0" />
         * <set-next-rule methodname="addSecurityRoleReference" /> </pattern>
         */

        /*
         * <!-- servlet-mapping --> <pattern value="sip-app/servlet-mapping">
         * <object-create-rule classname="com.ericsson.ssa.dd.ServletMapping" />
         * <call-method-rule pattern="servlet-name" methodname="setServletName"
         * paramcount="0" /> <set-next-rule methodname="addServletMapping" />
         * </pattern>
         */
        digester.addObjectCreate("sip-app/servlet-mapping",
            ServletMapping.class.getName(), "className");
        digester.addCallMethod("sip-app/servlet-mapping/servlet-name",
            "setServletName", 0);
        digester.addSetNext("sip-app/servlet-mapping", "addServletMapping",
            ServletMapping.class.getName());
        // <pattern value="sip-app/servlet-mapping/pattern">
        // <object-create-rule classname="com.ericsson.ssa.dd.Pattern" />
        // <set-next-rule methodname="setPattern" />
        // </pattern>
        digester.addObjectCreate("sip-app/servlet-mapping/pattern",
            Pattern.class.getName(), "className");
        digester.addSetNext("sip-app/servlet-mapping/pattern", "setPattern",
            Pattern.class.getName());
        // <!-- operator -->
        // <pattern value="* /and">
        // <object-create-rule classname="com.ericsson.ssa.dd.AndOperator" />
        // <set-next-rule methodname="addCondition" />
        // </pattern>
        digester.addObjectCreate("*/and", AndOperator.class.getName(),
            "className");
        digester.addRule("*/and", new SetOperator(digester));
        // <pattern value="* /or">
        // <object-create-rule classname="com.ericsson.ssa.dd.OrOperator" />
        // <set-next-rule methodname="addCondition" />
        // </pattern>
        digester.addObjectCreate("*/or", OrOperator.class.getName(), "className");
        digester.addRule("*/or", new SetOperator(digester));
        // <pattern value="* /not">
        // <object-create-rule classname="com.ericsson.ssa.dd.NotOperator" />
        // <set-next-rule methodname="addCondition" />
        // </pattern>
        digester.addObjectCreate("*/not", NotOperator.class.getName(),
            "className");
        digester.addRule("*/not", new SetOperator(digester));
        // <!-- operand -->
        // <pattern value="* /equal">
        // <object-create-rule classname="com.ericsson.ssa.dd.EqualOperand" />
        // <call-method-rule pattern="var" methodname="setVariable" paramcount="0"
        // />
        // <call-method-rule pattern="value" methodname="setValue" paramcount="0"
        // />
        // <set-next-rule methodname="addCondition" />
        // </pattern>
        digester.addObjectCreate("*/equal", EqualOperand.class.getName(),
            "className");
        // To set the ignore-case
        digester.addCallMethod("*/equal", "setIgnoreCase", 1);
        digester.addCallParam("*/equal", 0, "ignore-case");
        digester.addCallMethod("*/equal/var", "setVariable", 0);
        digester.addCallMethod("*/equal/value", "setValue", 0);
        digester.addRule("*/equal", new SetOperand(digester));
        /*
         * <pattern value="* /contains"> <object-create-rule
         * classname="com.ericsson.ssa.dd.ContainsOperand" /> <call-method-rule
         * pattern="var" methodname="setVariable" paramcount="0" />
         * <call-method-rule pattern="value" methodname="setValue" paramcount="0" />
         * <set-next-rule methodname="addCondition" /> </pattern>
         */
        digester.addObjectCreate("*/contains", ContainsOperand.class.getName(),
            "className");
        // To set the ignore-case
        digester.addCallMethod("*/contains", "setIgnoreCase", 1);
        digester.addCallParam("*/contains", 0, "ignore-case");
        digester.addCallMethod("*/contains/var", "setVariable", 0);
        digester.addCallMethod("*/contains/value", "setValue", 0);
        digester.addRule("*/contains", new SetOperand(digester));
        /* <pattern value="* /exists"> <object-create-rule
        * classname="com.ericsson.ssa.dd.ExistsOperand" /> <call-method-rule
        * pattern="var" methodname="setVariable" paramcount="0" /> <set-next-rule
        * methodname="addCondition" />
        */
        digester.addObjectCreate("*/exists", ExistsOperand.class.getName(),
            "className");
        digester.addCallMethod("*/exists/var", "setVariable", 0);
        digester.addRule("*/exists", new SetOperand(digester));
        /* </pattern> <pattern value="* /subdomain-of"> <object-create-rule
        * classname="com.ericsson.ssa.dd.SubDomainOfOperand" /> <call-method-rule
        * pattern="var" methodname="setVariable" paramcount="0" />
        * <call-method-rule pattern="value" methodname="setValue" paramcount="0" />
        * <set-next-rule methodname="addCondition" /> </pattern>
        */
        digester.addObjectCreate("*/subdomain-of",
            SubDomainOfOperand.class.getName(), "className");
        digester.addCallMethod("*/subdomain-of/var", "setVariable", 0);
        digester.addCallMethod("*/subdomain-of/value", "setValue", 0);
        digester.addRule("*/subdomain-of", new SetOperand(digester));

        digester.addCallMethod("sip-app/login-config/auth-method",
            "setLoginConfigAuthMethod", 0);
        digester.addCallMethod("sip-app/login-config/realm-name",
            "setLoginConfigRealmName", 0);

        digester.addObjectCreate("sip-app/security-constraint",
            SecurityConstraint.class.getName(), "className");
        digester.addCallMethod("sip-app/security-constraint/display-name",
            "setDisplayName", 0);
        digester.addCallMethod("sip-app/security-constraint/proxy-authenticated",
            "setProxyAuthenticated", 0);

        digester.addCallMethod("sip-app/security-constraint/auth-constraint/description",
            "setAuthorizationConstraintDescription", 0);
        digester.addCallMethod("sip-app/security-constraint/auth-constraint/role-name",
            "addAuthorizationConstraintRoleNames", 0);

        digester.addCallMethod("sip-app/security-constraint/user-data-constraint/description",
            "setUserDataConstraintDescription", 0);
        digester.addCallMethod("sip-app/security-constraint/user-data-constraint/transport-guarantee",
            "setUserDataTransportGuarantee", 0);

        digester.addObjectCreate("sip-app/security-constraint/resource-collection",
            ResourceCollection.class.getName(), "className");
        digester.addCallMethod("sip-app/security-constraint/resource-collection/description",
            "setDescription", 0);
        digester.addCallMethod("sip-app/security-constraint/resource-collection/resource-name",
            "setName", 0);
        digester.addCallMethod("sip-app/security-constraint/resource-collection/servlet-name",
            "addServletName", 0);
        digester.addCallMethod("sip-app/security-constraint/resource-collection/sip-method",
            "addSipMethod", 0);

        digester.addSetNext("sip-app/security-constraint/resource-collection",
            "addResourceCollection", ResourceCollection.class.getName());

        digester.addSetNext("sip-app/security-constraint",
            "addSecurityConstraint", SecurityConstraint.class.getName());

        //  	<pattern value="sip-app/security-constraint">
        //
        //	<object-create-rule classname="com.ericsson.ssa.dd.SecurityConstraint" />
        //	<call-method-rule pattern="display-name" methodname="setDisplayName" paramcount="0" />
        //	<call-method-rule pattern="proxy-authentication" methodname="setProxyAuthenticated" />
        //	
        //	<pattern value="resource-collection">
        //		<object-create-rule classname="com.ericsson.ssa.dd.ResourceCollection" />
        //		<call-method-rule pattern="description" methodname="setDescription" paramcount="0" />
        //		<call-method-rule pattern="resource-name" methodname="setName" paramcount="0" />
        //		<call-method-rule pattern="servlet-name" methodname="addServletName" paramcount="0" />
        //		<call-method-rule pattern="sip-method" methodname="addSipMethod" paramcount="0" />
        //		<set-next-rule methodname="addResourceCollection" />
        //	</pattern>
        //	<pattern value="auth-constraint">
        //		<call-method-rule pattern="description" methodname="setAuthorizationConstraintDescription" paramcount="0" />
        //		<call-method-rule pattern="role-name" methodname="addAuthorizationConstraintRoleNames" paramcount="0" />
        //	</pattern>
        //	<pattern value="user-data-constraint">
        //		<call-method-rule pattern="description" methodname="setUserDataConstraintDescription" paramcount="0" />
        //		<call-method-rule pattern="transport-guarantee" methodname="setUserDataTransportGuarantee" paramcount="0" />
        //	</pattern>
        //	<set-next-rule methodname="addSecurityConstraint" />
        //</pattern>
        digester.addCallMethod("sip-app/security-constraint/proxy-authentication",
            "setProxyAuthenticated", 0);

        /*
        * <!-- resource-env-ref --> <pattern value="sip-app/resource-env-ref">
        * <object-create-rule
        * classname="com.ericsson.ssa.dd.ResourceEnvironmentReference" />
        * <call-method-rule pattern="description" methodname="setDescription"
        * paramcount="0" /> <call-method-rule pattern="resource-env-ref-name"
        * methodname="setName" paramcount="0" /> <call-method-rule
        * pattern="resource-env-ref-type" methodname="setType" paramcount="0" />
        * <set-next-rule methodname="addResourceEnvironmentReference" />
        * </pattern> <!-- resource-ref --> <pattern value="sip-app/resource-ref">
        * <object-create-rule classname="com.ericsson.ssa.dd.ResourceReference" />
        * <call-method-rule pattern="description" methodname="setDescription"
        * paramcount="0" /> <call-method-rule pattern="res-ref-name"
        * methodname="setName" paramcount="0" /> <call-method-rule
        * pattern="res-type" methodname="setType" paramcount="0" />
        * <call-method-rule pattern="res-auth" methodname="setAuthentication"
        * paramcount="0" /> <call-method-rule pattern="res-sharing-scope"
        * methodname="setSharingScope" paramcount="0" /> <set-next-rule
        * methodname="addResourceReference" /> </pattern> <!--
        * security-constraint --> <pattern value="sip-app/security-constraint">
        * <object-create-rule classname="com.ericsson.ssa.dd.SecurityConstraint" />
        * <call-method-rule pattern="display-name" methodname="setDisplayName"
        * paramcount="0" /> <call-method-rule pattern="proxy-authentication"
        * methodname="setProxyAuthenticated" /> <pattern
        * value="resource-collection"> <object-create-rule
        * classname="com.ericsson.ssa.dd.ResourceCollection" /> <call-method-rule
        * pattern="description" methodname="setDescription" paramcount="0" />
        * <call-method-rule pattern="resource-name" methodname="setName"
        * paramcount="0" /> <call-method-rule pattern="servlet-name"
        * methodname="addServletName" paramcount="0" /> <call-method-rule
        * pattern="sip-method" methodname="addSipMethod" paramcount="0" />
        * <set-next-rule methodname="addResourceCollection" /> </pattern>
        * <pattern value="auth-constraint"> <call-method-rule
        * pattern="description"
        * methodname="setAuthorizationConstraintDescription" paramcount="0" />
        * <call-method-rule pattern="role-name"
        * methodname="addAuthorizationConstraintRoleNames" paramcount="0" />
        * </pattern> <pattern value="user-data-constraint"> <call-method-rule
        * pattern="description" methodname="setUserDataConstraintDescription"
        * paramcount="0" /> <call-method-rule pattern="transport-guarantee"
        * methodname="setUserDataTransportGuarantee" paramcount="0" /> </pattern>
        * <set-next-rule methodname="addSecurityConstraint" /> </pattern>
        * <pattern value="sip-app/login-config"> <call-method-rule
        * pattern="auth-method" methodname="setLoginConfigAuthMethod"
        * paramcount="0" /> <call-method-rule pattern="realm-name"
        * methodname="setLoginConfigRealmName" paramcount="0" /> </pattern>
        * <pattern value="sip-app/security-role"> <object-create-rule
        * classname="com.ericsson.ssa.dd.SecurityRole" /> <call-method-rule
        * pattern="role-name" methodname="setName" paramcount="0" />
        * <call-method-rule pattern="description" methodname="setDescription"
        * paramcount="0" /> <set-next-rule methodname="addSecurityRole" />
        * </pattern> <pattern value="sip-app/env-entry"> <object-create-rule
        * classname="com.ericsson.ssa.dd.EnvironmentEntry" /> <call-method-rule
        * pattern="description" methodname="setDescription" paramcount="0" />
        * <call-method-rule pattern="env-entry-name" methodname="setName"
        * paramcount="0" /> <call-method-rule pattern="env-entry-value"
        * methodname="setValue" paramcount="0" /> <call-method-rule
        * pattern="env-entry-type" methodname="setType" paramcount="0" />
        * <set-next-rule methodname="addEnvironmentEntry" /> </pattern> <pattern
        * value="sip-app/ejb-ref"> <object-create-rule
        * classname="com.ericsson.ssa.dd.EjbReference" /> <call-method-rule
        * pattern="description" methodname="setDescription" paramcount="0" />
        * <call-method-rule pattern="ejb-ref-name" methodname="setName"
        * paramcount="0" /> <call-method-rule pattern="ejb-ref-type"
        * methodname="setType" paramcount="0" /> <call-method-rule pattern="home"
        * methodname="setHome" paramcount="0" /> <call-method-rule
        * pattern="remote" methodname="setRemote" paramcount="0" />
        * <call-method-rule pattern="ejb-link" methodname="setEjbLink"
        * paramcount="0" /> <set-next-rule methodname="addEjbReference" />
        * </pattern> <pattern value="sip-app/ejb-local-ref"> <object-create-rule
        * classname="com.ericsson.ssa.dd.EjbLocalReference" /> <call-method-rule
        * pattern="description" methodname="setDescription" paramcount="0" />
        * <call-method-rule pattern="ejb-ref-name" methodname="setName"
        * paramcount="0" /> <call-method-rule pattern="ejb-ref-type"
        * methodname="setType" paramcount="0" /> <call-method-rule
        * pattern="local-home" methodname="setLocalHome" paramcount="0" />
        * <call-method-rule pattern="local" methodname="setLocal" paramcount="0" />
        * <call-method-rule pattern="ejb-link" methodname="setEjbLink"
        * paramcount="0" /> <set-next-rule methodname="addEjbLocalReference" />
        * </pattern>
        */
    }
}
