/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.dd;

import java.util.ArrayList;
import java.util.Hashtable;

import javax.servlet.sip.SipServletRequest;


public class SubDomainOfOperand extends Operand {
    /**
          *
          */
    private static final long serialVersionUID = 1L;

    /**
    * Specifies a variable
    */
    private String variable;

    /**
     * Specifies a literal string value that is used to specify rules
     */
    private String value;

    /**
     * Evaluate the condition
     *
     * @param object
     *        The object to evaluate
     * @return True if the operand or operator evaluation is satisfied, false
     *         otherwise
     */
    public boolean evaluate(Object object) {
        String actualValue = getAttributeValue(variable,
                (SipServletRequest) object);

        if (actualValue.endsWith(value)) {
            int len1 = actualValue.length();
            int len2 = value.length();

            return ((len1 == len2) ||
            (actualValue.charAt(len1 - len2 - 1) == '.'));
        }

        return false;

        //throw new UnsupportedOperationException("Method needs implementation");
    }

    /**
     * Returns the method session case list
     *
     * @return A hashtable of the method session case
     * @throws SipParserException
     */
    public Hashtable<String, ArrayList<String>> getMethodSessionCaseList()
        throws SipParserException {
        throw new UnsupportedOperationException("Method needs implementation");
    }

    /**
     * @return
     */
    public String getVariable() {
        return variable;
    }

    /**
     * @param variable
     */
    public void setVariable(String variable) {
        this.variable = variable;
    }

    /**
     * @return
     */
    public String getValue() {
        return value;
    }

    /**
     * @param value
     */
    public void setValue(String value) {
        this.value = value;
    }
}
