/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.dd;

import java.util.Collection;


public class SupportedMethod extends Enum {
    public static final SupportedMethod INVITE = new SupportedMethod("INVITE");
    public static final SupportedMethod OPTIONS = new SupportedMethod("OPTIONS");
    public static final SupportedMethod REGISTER = new SupportedMethod(
            "REGISTER");
    public static final SupportedMethod SUBSCRIBE = new SupportedMethod(
            "SUBSCRIBE");
    public static final SupportedMethod NOTIFY = new SupportedMethod("NOTIFY");
    public static final SupportedMethod MESSAGE = new SupportedMethod("MESSAGE");

    private SupportedMethod(String name) {
        super(name);
    }

    public static boolean contains(String name) {
        return Enum.contains(SupportedMethod.class, name);
    }

    public static String printNames() {
        return Enum.toString(SupportedMethod.class);
    }

    public static Collection getEnumNameList() {
        return Enum.getEnumNameList(SupportedMethod.class);
    }
}
