/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.fm;

import java.util.HashMap;
import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;


/**
 * This class handles notification and alarms to be raised.
 *
 * @author edtugdi, epiesan
 * @since 2005-aug-11
 */
public class FmEventSender {
    private final static Logger logger = Logger.getLogger("SipContainer");

    //-------- NOTIFICATIONS ---//

    /**
     * Application Deployed Successfully Notification
     * @param contextName The application name
     */
    public static void applicationDeployedSuccessfully(String contextName) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Application", contextName);
        logger.log(Level.WARNING,
            "applicationDeployedSuccessfully - Not implemented notification");

        /*
        Notification notification = FmFactory.getInstance().getNotificationManager();
        notification.sendNotification(FmTypes.EAS_APPLICATION_DEPLOYMENT_FINISHED_SUCCESSFULLY,
                                      FmTypes.OBJECT_TYPE_EAS,
                                      FmTypes.INSTANCE_SIP_CONTAINER,
                                      param);
                                      */
    }

    /**
     * Application Deployment Started Notification
     * @param contextName The application name
     *
     */
    public static void applicationDeploymentStarted(String contextName) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Application", contextName);
        logger.log(Level.WARNING,
            "applicationDeploymentStarted - Not implemented notification");

        /*
        Notification notification = FmFactory.getInstance().getNotificationManager();
        notification.sendNotification(FmTypes.EAS_APPLICATION_DEPLOYMENT_STARTED,
                                      FmTypes.OBJECT_TYPE_EAS,
                                      FmTypes.INSTANCE_SIP_CONTAINER,
                                      param);
                                      */
    }

    /**
     * Application Deployment Failed Notification
     * @param contextName The application name
     * @param reason The reason to failure
     */
    public static void applicationDeploymentFailed(String contextName,
        String reason) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Application", contextName);
        param.put("Reason to failure", reason);
        logger.log(Level.WARNING,
            "applicationDeploymentFailed - Not implemented notification");

        /*
        Notification notification = FmFactory.getInstance().getNotificationManager();
        notification.sendNotification(FmTypes.EAS_APPLICATION_DEPLOYMENT_FAILED,
                                      FmTypes.OBJECT_TYPE_EAS,
                                      FmTypes.INSTANCE_SIP_CONTAINER,
                                      param);
                                      */
    }

    /**
     * Application Undeployed Successfully Notification
     * @param contextName The application name
     */
    public static void applicationUndeployedSuccessfully(String contextName) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Application", contextName);
        logger.log(Level.WARNING,
            "applicationUndeployedSuccessfully - Not implemented notification");

        /*
        Notification notification = FmFactory.getInstance().getNotificationManager();
        notification.sendNotification(FmTypes.EAS_APPLICATION_UNDEPLOYMENT_FINISHED_SUCCESSFULLY,
                                      FmTypes.OBJECT_TYPE_EAS,
                                      FmTypes.INSTANCE_SIP_CONTAINER,
                                      param);
                                      */
    }

    /**
     * Application Deployment Started Notification
     * @param contextName The application name
     *
     */
    public static void applicationUndeploymentStarted(String contextName) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Application", contextName);
        logger.log(Level.WARNING,
            "applicationUndeploymentStarted - Not implemented notification");

        /*
        Notification notification = FmFactory.getInstance().getNotificationManager();
        notification.sendNotification(FmTypes.EAS_APPLICATION_UNDEPLOYMENT_STARTED,
                                      FmTypes.OBJECT_TYPE_EAS,
                                      FmTypes.INSTANCE_SIP_CONTAINER,
                                      param);
                                      */
    }

    /**
     * Application Deployment Failed Notification
     * @param contextName The application name
     * @param reason The reason to failure
     */
    public static void applicationUndeploymentFailed(String contextName,
        String reason) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Application", contextName);
        param.put("Reason to failure", reason);
        logger.log(Level.WARNING,
            "applicationUndeploymentFailed - Not implemented notification");

        /*
        Notification notification = FmFactory.getInstance().getNotificationManager();
        notification.sendNotification(FmTypes.EAS_APPLICATION_UNDEPLOYMENT_FAILED,
                                      FmTypes.OBJECT_TYPE_EAS,
                                      FmTypes.INSTANCE_SIP_CONTAINER,
                                      param);
                                      */
    }

    /**
     * Servlet Initialization Failed Notification
     * @param contextName The application name
     * @param servletName The servlet name
     * @param reason The reason to fail
     */
    public static void servletInitializationFailed(String contextName,
        String servletName, String reason) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Application", contextName);
        param.put("Servlet", servletName);
        param.put("Reason to failure", reason);
        logger.log(Level.WARNING,
            "servletInitializationFailed - Not implemented notification");

        /*
        Notification notification = FmFactory.getInstance().getNotificationManager();
        notification.sendNotification(FmTypes.EAS_SERVLET_INITIALIZATION_FAILED,
                                      FmTypes.OBJECT_TYPE_EAS,
                                      FmTypes.INSTANCE_SIP_CONTAINER,
                                      param);
                                      */
    }

    //------ ALARMS --------/

    /**
     * Clear all existing Traffic Module alarms.
     */
    public static void clearAlarms() {
        clearAlarmCpuLoadLimitExceeded();
    }

    public static void clearAlarmCpuLoadLimitExceeded() {
        logger.log(Level.WARNING,
            "clearAlarmCpuLoadLimitExceeded - Not implemented alarm");

        /*
        Alarm alarm = FmFactory.getInstance().getAlarmManager();
        try
        {
           alarm.clearAlarm(FmTypes.OBJECT_TYPE_EAS, FmTypes.INSTANCE_SIP_CONTAINER,
                 FmTypes.ALARM_CPU_LOAD_LIMIT_EXCEEDED, null, true);  // Fix for HH34467
        }
        catch(FmCannotSendRequestException e)
        {
           logger.log(Level.SEVERE, "Got an exception when clearing the alarm", e);
        }
        */
    }

    /**
     * Raise an alarm when CPU load limit exceeded.
     *
     * @param reason Reason to failure.
     */
    public static void raiseAlarmCpuLoadLimitExceeded(String reason) {
        logger.log(Level.WARNING,
            "raiseAlarmCpuLoadLimitExceeded - Not implemented alarm");

        /*
        if (reason == null)
        {
           reason = FmTypes.DESC_ALARM_CPU_LOAD_LIMIT_EXCEEDED;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Specific Event MOC", FmTypes.OBJECT_TYPE_EAS);
        param.put("Reason for issued alarm", reason);
        param.put("IRP Cause", "310");
        param.put("Specific Problems", FmTypes.CPU_ALARM_PROBABLE_CAUSE);

        Alarm alarm = FmFactory.getInstance().getAlarmManager();
        try
        {
           alarm.raiseAlarm(FmTypes.ALARM_TYPE_PROCESSING_ERROR,
                 FmTypes.OBJECT_TYPE_EAS,
                 FmTypes.INSTANCE_SIP_CONTAINER,
                 FmTypes.ALARM_CPU_LOAD_LIMIT_EXCEEDED,
                 FmTypes.ALARM_SEVERITY_CRITICAL,
                 FmTypes.CPU_ALARM_PROBABLE_CAUSE,
                 param,
                 true);       // Fix for HH34467
        }
        catch(FmCannotSendRequestException e)
        {
           logger.log(Level.SEVERE, "Got an exception when try to raise an alarm", e);
        }
        */
    }
}
