/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.fm;


/**
 * This is a interface used as a helper for notification and alarm handling in
 * TM
 *
 * @author edtugdi
 * @since 2005-maj-21
 * @reviewed ejoelbi 2006-nov-22
 */
public interface FmTypes {
    public final static String OBJECT_TYPE_EAS = "EAS";
    public final static String INSTANCE_SIP_CONTAINER = "TrafficModule";

    // Notifications
    public final static int EAS_APPLICATION_DEPLOYMENT_STARTED = 3;
    public final static int EAS_APPLICATION_DEPLOYMENT_FINISHED_SUCCESSFULLY = 4;
    public final static int EAS_APPLICATION_DEPLOYMENT_FAILED = 5;
    public final static int EAS_APPLICATION_UNDEPLOYMENT_STARTED = 6;
    public final static int EAS_APPLICATION_UNDEPLOYMENT_FINISHED_SUCCESSFULLY = 7;
    public final static int EAS_APPLICATION_UNDEPLOYMENT_FAILED = 8;
    public final static int EAS_SERVLET_INITIALIZATION_FAILED = 9;

    // Alarms
    public final static int ALARM_DNS_UNREACHABLE = 1;
    public final static String DESC_DNS_UNREACHABLE = "DNS Unreachable";
    public final static int ALARM_CPU_LOAD_LIMIT_EXCEEDED = 2;
    public final static String DESC_ALARM_CPU_LOAD_LIMIT_EXCEEDED = "CPU load limit exceeded";
    public final static int ALARM_TYPE_COMMUNICATIONS = 0;
    public final static int ALARM_TYPE_QUALITY_OF_SERVICE = 1;
    public final static int ALARM_TYPE_PROCESSING_ERROR = 2;
    public final static int ALARM_TYPE_EQUIPMENT = 3;
    public final static int ALARM_TYPE_ENVIRONMENTAL = 4;
    public final static int ALARM_SEVERITY_INDETERMINATE = 0;
    public final static int ALARM_SEVERITY_CRITICAL = 1;
    public final static int ALARM_SEVERITY_MAJOR = 2;
    public final static int ALARM_SEVERITY_MINOR = 3;
    public final static int ALARM_SEVERITY_WARNING = 4;
    public final static int ALARM_SEVERITY_CLEARED = 5;
    public final static String ALARM_PROBABLE_CAUSE = "EAS, DNS Unreachable";
    public final static String CPU_ALARM_PROBABLE_CAUSE = "EAS, CPU Load Limit Exceeded";
}
