/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.router;

import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationRouter;
import javax.servlet.sip.SipApplicationRouterInfo;
import javax.servlet.sip.SipApplicationRoutingDirective;
import javax.servlet.sip.SipApplicationRoutingRegion;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipRouteModifier;
import javax.servlet.sip.SipServletReadOnlyRequest;


public class AlphabeticalRouter implements SipApplicationRouter {
    private SortedSet<String> deployedApps = new TreeSet<String>();
    @javax.servlet.sip.annotation.SipFactory
    private SipFactory sipFactory;
    private Logger log = Logger.getLogger("SipContainer");

    public void init() {
    	if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Init()");
        }
    	deployedApps = new TreeSet<String>();
}
    
    public void init(List<String> applications) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Init : Deployed Apps -> " + applications);
        }

        deployedApps = new TreeSet<String>(applications);
    }

    public void destroy() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Destroy");
        }

        deployedApps = null;
    }

    public void applicationDeployed(List<String> applications) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "DeployedApplications");
        }

        for (String app : applications) {
            if (!deployedApps.contains(app)) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Adding new Application : " + app);
                }

                deployedApps.add(app);
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Upgraded Application : " + app);
                }
            }
        }
    }

    public void applicationUndeployed(List<String> applications) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "UndeployedApplications");
        }

        for (String app : applications) {
            boolean removed = deployedApps.remove(app);

            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE,
                    "Removed Application : " + app + " = " + removed);
            }
        }
    }

    /*
     * Only checks the state info since each request is traversed by all
     * applications in the alphabetical order
     */

	public SipApplicationRouterInfo getNextApplication(
			SipServletReadOnlyRequest initialRequest,
			SipApplicationRoutingRegion region,
			SipApplicationRoutingDirective directive, Serializable stateInfo) {
        SipApplicationRouterInfo info = null;
        String subscriberURI = ""; // TODO implement

        String app = null;

        if (stateInfo == null) { // First time

            if (deployedApps != null) {
                try {
                    app = deployedApps.first();
                } catch (RuntimeException re) {
                    ;
                }
            }
        } else {
            boolean match = false;

            for (String x : deployedApps) {
                if (match) {
                    app = x;

                    break;
                }

                if (stateInfo.equals(x)) {
                    match = true;
                }
            }
        }

        if (app == null) { // Go External

            Address target = null;

            try {
                target = initialRequest.getAddressHeader("Route");

                if (target == null) {
                    target = sipFactory.createAddress(initialRequest.getRequestURI());
                }
            } catch (ServletParseException e) {
            	log.severe(
        			"Could not create targetAdress based on request URI! " + e);
            }
            SipRouteModifier modifier = SipRouteModifier.ROUTE;

            info = new SipApplicationRouterInfo(
            		null, // next application name, external so null
            		null, // routing region, external so null
            		null, // served subscriber URI, external so null
            		target.toString(),
            		modifier, 
            		null); // stateinfo TODO should we pass existing state info?
        } else { 
        	// internal application selected
            // TODO what should the route and route modifier be?
            String route = "";
            SipRouteModifier modifier = SipRouteModifier.NO_ROUTE;
            info = new SipApplicationRouterInfo(
        		app, // next application name
        		region, // region in which app will serve, use unchanged
        		subscriberURI, // served subscriber URI
        		route,
        		modifier,
                app ); // application name used as stateinfo
        }

        return info;
    }

	public void configurationChanged(InputStream configInputStream) {
		// TODO Auto-generated method stub
		
	}

//    private SessionCaseRegion getSessionCase(Address poppedRoute) {
//        if (poppedRoute == null) {
//            return SessionCaseRegion.UNKNOWN;
//        }
//
//        String sessionCase = poppedRoute.getParameter("call");
//
//        if ("orig".equalsIgnoreCase(sessionCase)) {
//            return SessionCaseRegion.ORIGINATING;
//        } else if ("terminating_registered".equalsIgnoreCase(sessionCase)) {
//            return SessionCaseRegion.TERMINATING_REG;
//        } else if ("terminating_unregistered".equalsIgnoreCase(sessionCase)) {
//            return SessionCaseRegion.TERMINATING_UNREG;
//        } else {
//            return SessionCaseRegion.UNKNOWN;
//        }
//    }
//    protected enum SessionCaseRegion {UNKNOWN,
//        ORIGINATING,
//        TERMINATING_REG,
//        TERMINATING_UNREG;
//    }
}
