/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip;

import javax.servlet.sip.ServletParseException;


/**
 * Header validation against something that should be interpreted as address, e.g. From and To headers.
 *
 * @author qmaghes
 *
 */
public class AddressHeaderValidator extends BasicMandatoryHeaderValidator {
    public AddressHeaderValidator(String headerName) {
        super(headerName);
    }

    public boolean validate(SipServletMessageImpl message) {
        // Parse and Validate Header
        Header header = message.getRawHeader(headerName);

        if ((header == null) || (header.getValue() == null) ||
                (header.getValue().length() == 0)) {
            return false;
        }

        try {
            /**
             * Delegate validation to address getter.
             */
            header.getAddressValue();

            return true;
        } catch (ServletParseException e) {
            return false;
        }
    }
}
