/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip;

import javax.servlet.sip.Address;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;


/**
 * This class represents something that can be either a Address object or a
 * plain non-interpreted string value. It captures the duality nature of headers.
 *
 * @author qmaghes
 *
 */
public class AddressOrValue implements Cloneable {
    /**
     *  String representation.
     */
    public String value = null;

    /**
     *
     *  Address representation.
     */
    public Address address = null;

    public Parameterable parameterable = null;

    private AddressOrValue() {
    }

    public AddressOrValue(String value) {
        if (value == null) {
            throw new NullPointerException("Requires proper value");
        }

        this.value = value;
    }

    public AddressOrValue(Address address) {
        if (address == null) {
            throw new NullPointerException("Requires proper address");
        }

        this.address = address;
    }

    public AddressOrValue(Parameterable parameterable) {
        if (parameterable == null) {
            throw new NullPointerException("Requires proper Parameterable");
        }
        this.parameterable = parameterable;
    }


    public Object clone() {
        AddressOrValue clone = new AddressOrValue();
        clone.value = value;

        if (address != null) {
            clone.address = (Address) ((AddressImpl) address).clone(true, true);
        }

        if (parameterable != null) {
            clone.parameterable = (Parameterable) parameterable.clone();
        }

        return clone;
    }

    public Address getAddressValue() throws ServletParseException {
        if ((address == null) && (value != null)) {
            address = SipFactoryImpl.getInstance().createAddress(value);
            value = null;
        }

        return address;
    }

    public void setAddressValue(Address address) {
        this.address = address;
        this.value = null;
    }

    public Parameterable getParameterableValue() throws ServletParseException {
        if ((parameterable == null) && (value != null)) {
            parameterable = SipFactoryImpl.getInstance().createParameterable(value);
            value = null;
        }

        return parameterable;
    }

    public void setParameterableValue(Parameterable parameterable) {
        this.parameterable = parameterable;
        this.value = null;
        
    }

    public String toString() {
        // Future improvement:
        // Doing address.toString() every time might be
        // resource consuming. A state consisting of the address hashCode
        // might be used. In such a implementation the hash code of the address
        // object is calculated and if it matches the saved state value can be returned
        // directly.
        // Such an implementation requires a good hashCode() implementation in AddressImpl.
        if (address != null) {
            return address.toString();
        } else if (parameterable != null) {
            return parameterable.toString();
        } else if (value != null) {
            return value;
        }

        return "";
    }

    public void setValue(String value) {
        this.address = null;
         this.parameterable = null;
        this.value = value;
    }
}
