/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.UAMode;


public class B2buaHelperPendingMessages {
    private static final Comparator<SipServletMessageImpl> CSEQ_INCREASE_ORDER = new Comparator<SipServletMessageImpl>() {
            public int compare(SipServletMessageImpl m1,
                SipServletMessageImpl m2) {
                return m1.getCSeqNumber() - m2.getCSeqNumber();
            }
        };

    private List<SipServletMessageImpl> uacMessage = null;
    private List<SipServletMessageImpl> uasMessage = null;

    public List<SipServletMessage> get(UAMode mode) {
        List<SipServletMessageImpl> list = null;

        switch (mode) {
        case UAC:
            list = getUACList();

            return get(list);

        case UAS:
            list = getUASList();

            return get(list);
        }

        throw new IllegalArgumentException("UAMode not supported: " + mode);
    }

    private synchronized List<SipServletMessageImpl> getUACList() {
        if (uacMessage == null) {
            uacMessage = new ArrayList<SipServletMessageImpl>();
        }

        return uacMessage;
    }

    private synchronized List<SipServletMessageImpl> getUASList() {
        if (uasMessage == null) {
            uasMessage = new ArrayList<SipServletMessageImpl>();
        }

        return uasMessage;
    }

    private List<SipServletMessage> get(List<SipServletMessageImpl> list) {
        synchronized (list) {
            // remove the message that is committed
            for (Iterator<SipServletMessageImpl> it = list.iterator();
                    it.hasNext();) {
                if (it.next().isCommitted()) {
                    it.remove();
                }
            }

            // sort the messages in CSeq increasing order
            Collections.sort(list, CSEQ_INCREASE_ORDER);

            return new ArrayList<SipServletMessage>(list);
        }
    }

    public void add(SipServletMessageImpl m, UAMode mode) {
        switch (mode) {
        case UAC:
            add(m, uacMessage);

            break;

        case UAS:
            add(m, uasMessage);

            break;

        default:
            throw new IllegalArgumentException("UAMode not supported: " + mode);
        }
    }

    private void add(SipServletMessageImpl m, List<SipServletMessageImpl> list) {
        synchronized (list) {
            list.add(m);
        }
    }

    public void remove(SipServletMessageImpl m, UAMode mode) {
        switch (mode) {
        case UAC:
            remove(m, uacMessage);

            break;

        case UAS:
            remove(m, uasMessage);

            break;

        default:
            throw new IllegalArgumentException("UAMode not supported: " + mode);
        }
    }

    private void remove(SipServletMessageImpl m,
        List<SipServletMessageImpl> list) {
        synchronized (list) {
            list.remove(m);
        }
    }
}
