/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip;

import java.util.regex.Pattern;


/**
 * Implementation of commonalities among header validators
 *
 * @author qmaghes
 *
 */
public abstract class BasicMandatoryHeaderValidator
    implements MandatoryHeaderValidator {
    // Reqexp translated from BNF notation in RFC 3261
    //
    // Token accepts single quote which is not correct RFC 3261, but is axxepted as
    // rfc4475 (Sip Torture Text messages) allows it.
    private static final String REGEXP_TOKEN = "[a-zA-Z1234567890\\-.!%*_+`´~']+"; // One or more of the character in brackets
    private static final String REGEXP_LWS = "(([ \t]*)(\r\n)){0,1}[ \t]+"; // LWS i.e. possibly (zero or more whitespaces plus CRLF) followed by (one or more whitespaces)
    private Pattern tokenPattern = Pattern.compile(REGEXP_TOKEN);
    private Pattern lswPattern = Pattern.compile(REGEXP_LWS);
    String headerName;

    public BasicMandatoryHeaderValidator(String headerName) {
        this.headerName = headerName;
    }

    /**
     * Check if the string is a token according to RFC 3261
     *
     * @param aString
     * @return
     */
    protected boolean isToken(String aString) {
        return tokenPattern.matcher(aString).matches();
    }

    /**
     * Split string into parts separated by LWS (RFC 3261)
     *
     * @param toSplit
     * @return
     */
    protected String[] splitLWS(String toSplit) {
        return lswPattern.split(toSplit);
    }

    public String getHeaderName() {
        return headerName;
    }
}
