/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip;


/**
 * Validation of the CSeq header.
 *
 *
 * @author qmaghes
 *
 */
public class CSeqHeaderValidator extends BasicMandatoryHeaderValidator {
    public static final long LIMIT_32BIT_UNSIGNED = 0x100000000L;

    public CSeqHeaderValidator() {
        super(Header.CSEQ);
    }

    public boolean validate(SipServletMessageImpl message) {
        Header header = message.getRawHeader(Header.CSEQ);

        if ((header == null) || (header.getValue() == null) ||
                (header.getValue().length() == 0)) {
            return false;
        }

        String value = header.getValue();

        // CSeq is "1*DIGIT LWS METHOD" 
        String[] parts = splitLWS(value);

        if (parts.length != 2) {
            return false;
        }

        return isNumber(parts[0]) && isMethod(parts[1]);
    }

    /**
     * Check is <code>method<method> matches "Method" i.e. "extension-method" according to rfc 3261.
     *
     * @param method
     * @return
     */
    private boolean isMethod(String method) {
        return isToken(method);
    }

    /**
     *         Check that the integer part is an unsigned 32 bit int.
     *
     * @param numberPart
     * @return
     */
    private boolean isNumber(String numberPart) {
        try {
            long cseqNumber = Long.parseLong(numberPart);

            if ((cseqNumber < 0) || (cseqNumber >= LIMIT_32BIT_UNSIGNED)) {
                return false;
            }

            // number part ok
            return true;
        } catch (NumberFormatException e) {
            return false;
        }
    }
}
