/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip;

import java.lang.reflect.Method;


/**
 * @author ekrigro
 */
public final class LayerHelper {
    public static void next(SipServletRequestImpl req, Layer layer,
        Layer nextLayer) {
        if (nextLayer == null) {
            layer.dispatch(req);
        } else {
            nextLayer.next(req);
        }
    }

    public static void next(SipServletResponseImpl resp, Layer layer,
        Layer nextLayer) {
        if (nextLayer == null) {
            layer.dispatch(resp);
        } else {
            nextLayer.next(resp);
        }
    }

    /**
     * Returns the singelton instance of a class implementing Layer Requirements
     * of the class as specified in "className" 1. The class has to implement the
     * Singelton pattern with the method getInstance() to retreive the singelton
     * instance. 2. The class has to implement the Layer interface
     *
     * @param className
     *        The fully qualified classname of the class implementing the Layer
     * @return A singelton instance of the class as specified by "className" OR
     *         null if the class does not comply to the condition of step 1 and 2
     */
    public static Layer getInstance(String className) {
        try {
            Class clazz = Class.forName(className);
            Method method = clazz.getMethod("getInstance", (Class[]) null);

            return (Layer) method.invoke((Object) null, (Object[]) null);
        } catch (Exception e) {
            return null;
        }
    }
}
