/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip;

import java.io.IOException;


/**
 * The proxy represantation of the dialog structure.
 *
 * @author ehsroha
 * @since 2005-maj-30
 */
public class ProxyContext implements PathNode {
    private final ProxyImpl _proxy;
    private SipSessionBase _session = null;

    public ProxyContext(ProxyImpl proxy, SipSessionBase session) {
        _proxy = proxy;
        _session = session;
    }

    public ProxyImpl getProxy() {
        return _proxy;
    }

    public Type getType() {
        return _proxy.getType();
    }

    public Object clone() {
        return new ProxyContext(getProxy(), getSipSession());
    }

    public synchronized SipSessionBase getSipSession() {
        return _session;
    }

    public synchronized void setSipSession(SipSessionBase session) {
        _session = session;
    }

    public SipApplicationSessionImpl getApplicationSession() {
        return _session.getApplicationSessionImpl();
    }

    public void send(SipServletRequestImpl req)
        throws IOException, IllegalStateException {
        throw new IllegalStateException(
            "Illegal to send from ProxyImpl, use proxyTo instead.");
    }

    public void send(SipServletResponseImpl resp)
        throws IOException, IllegalStateException {
        throw new IllegalStateException(
            "Illegal to send from ProxyImpl, use proxyTo instead.");
    }

    public void dispatch(SipServletRequestImpl req) {
        _proxy.dispatch(req, this);
    }

    public void dispatch(SipServletResponseImpl resp) {
        _proxy.dispatch(resp, this);
    }

    /**
     * Returns true if this PathNode is replicable, false otherwise.
     *
     * @return true if this PathNode is replicable, false otherwise
     */
    public boolean isReplicable() {
        return _session.isReplicable();
    }
}
