/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * Part of the Proxy implementation. There might be several SequentialTargetSet
 * per Proxy.
 *
 * @author ehsroha
 */
public class SequentialTargetSet extends TargetSet {
    private static final Logger _log = (Logger) Logger.getLogger("SipContainer");
    private List<TargetSet> _targetSets = null;
    private Iterator<TargetSet> _iter = null;
    private boolean _isStarted = false;
    private final boolean _isRecurse;

    /**
     * The constructor of the SequentialTargetSet implementation.
     *
     */
    public SequentialTargetSet(CreatedTargetSet t, boolean isRecurse) {
        super(t.getProxyImpl());
        _isRecurse = isRecurse;
        _targetSets = new ArrayList<TargetSet>(t.getTargetSets());

        for (TargetSet child : getTargetSets()) {
            child.setParent(this);
        }
    }

    @Override
    protected List<TargetSet> getTargetSets() {
        return _targetSets;
    }

    public boolean hasNext() {
        return _iter.hasNext();
    }

    public void next() {
        TargetSet t = _iter.next();

        try {
            t.proxyTo();
        } catch (IllegalStateException e) {
            if (_log.isLoggable(Level.WARNING)) {
                // FIXME more detailed error descr
                _log.log(Level.WARNING, "Failed to proxy request. ", e);
            }

            // remove from target set that does not work...
            getTargetSets().remove(t);
        }
    }

    public void proxyTo() throws IllegalStateException {
        if (isStarted()) {
            throw new IllegalStateException("Already started");
        }

        _isStarted = true;
        _iter = getTargetSets().iterator();

        if (hasNext()) {
            next();
        }
    }

    public void cancel() throws IllegalStateException {
        if (isStarted()) {
            for (TargetSet t : getTargetSets()) {
                t.cancel();
            }
        }
    }

    /**
     * Always return false
     *
     * @return always false
     */
    public boolean getParallel() {
        return false;
    }

    @Override
    public boolean isStarted() {
        return _isStarted;
    }

    @Override
    public boolean getRecurse() {
        return _isRecurse;
    }
}
