/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

import javax.servlet.sip.Address;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;


/**
 * @author ekrigro TODO To change the template for this generated type comment
 *         go to Window - Preferences - Java - Code Style - Code Templates
 */
public final class SingleLineHeader extends Header implements Externalizable {
    /**
     *
     */
    private static final long serialVersionUID = 3256437027846566967L;
    private AddressOrValue addressOrValue;

    /**
     * @param pretty
     * @param systemHeader
     */
    public SingleLineHeader(String pretty, boolean systemHeader) {
        super(pretty, systemHeader, true);
    }

    public SingleLineHeader() {
    } // Only for the Externalizable interface!

    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeUTF((addressOrValue != null) ? addressOrValue.toString() : "");
        super.writeExternal(output);
    }

    public void readExternal(ObjectInput input) throws IOException {
        addressOrValue = new AddressOrValue(input.readUTF());
        super.readExternal(input);
    }

    protected Object clone() {
        SingleLineHeader newHeader = new SingleLineHeader(new String(_name),
                _readOnly);

        if (addressOrValue != null) {
            newHeader.addressOrValue = (AddressOrValue) addressOrValue.clone();
        }

        return newHeader;
    }

    public String getValue() {
        if (addressOrValue != null) {
            return addressOrValue.toString();
        }

        return null;
    }

    public void setValue(String value, boolean ignore) {
        if (value != null) {
            if (addressOrValue == null) {
                addressOrValue = new AddressOrValue(value);
            } else {
                addressOrValue.setValue(value);
            }
        }
    }

    public Address getAddressValue() throws ServletParseException {
        if (addressOrValue != null) {
            Address address = addressOrValue.getAddressValue();

            // Even the address of a system header should be protected.
            ((AddressImpl) address).setReadOnly(_readOnly);

            return address;
        }

        return null;
    }

    public void setAddressValue(Address address, boolean first) {
        if (address != null) {
            if (addressOrValue == null) {
                addressOrValue = new AddressOrValue(address);
            } else {
                addressOrValue.setAddressValue(address);
            }
        }
    }

    public Parameterable getParameterableValue() throws ServletParseException {
        if (addressOrValue != null) {
            return addressOrValue.getParameterableValue();
        }

        return null;
    }

    public void setParameterableValue(Parameterable parameterable, boolean first) {
        if (parameterable != null) {
            if (addressOrValue == null) {
                addressOrValue = new AddressOrValue(parameterable);
            } else {
                addressOrValue.setParameterableValue(parameterable);
            }
        }
    }

    public ListIterator<String> getValues() {
        return new HeaderIterator<String>((addressOrValue != null)
            ? addressOrValue.toString() : null);
    }

    public ListIterator<Address> getAddressValues()
        throws ServletParseException {
        Address address = getAddressValue();

        // Even the address of a system header should be protected.
        ((AddressImpl) address).setReadOnly(_readOnly);

        return new HeaderIterator<Address>(address);
    }

    
    public ListIterator<Parameterable> getParameterableValues()
        throws ServletParseException {
        Parameterable parameterable = getParameterableValue();

        return new HeaderIterator<Parameterable>(parameterable);
    }

    public void removeValues() {
        addressOrValue = null;
    }

    public void merge(Header h) {
        throw new UnsupportedOperationException("Header = " + _name +
            " old val = " + String.valueOf(addressOrValue) + " merge with = " +
            h.getName() + " : " + h.getValue());
    }

    public String toString() {
        if (addressOrValue != null) {
            StringBuilder sb = new StringBuilder(_name);
            sb.append(": ");
            sb.append(addressOrValue.toString());
            sb.append(SipFactoryImpl.NEW_LINE);

            return sb.toString();
        }

        return "";
    }

    class HeaderIterator<T> implements ListIterator<T> {
        private ListIterator<T> _li;

        public HeaderIterator(T val) {
            List<T> l = new ArrayList<T>();

            if (val != null) {
                l.add(val);
            }

            _li = l.listIterator();
        }

        public void add(T o) {
            if (_readOnly) {
                throw new IllegalStateException(ILLEGAL_ACCESS);
            }

            throw new UnsupportedOperationException();

            // TODO implement
        }

        public boolean hasNext() {
            return _li.hasNext();
        }

        public boolean hasPrevious() {
            return _li.hasPrevious();
        }

        public T next() {
            return _li.next();
        }

        public int nextIndex() {
            return _li.nextIndex();
        }

        public T previous() {
            return _li.previous();
        }

        public int previousIndex() {
            return _li.previousIndex();
        }

        public void remove() {
            if (_readOnly) {
                throw new IllegalStateException(ILLEGAL_ACCESS);
            }

            throw new UnsupportedOperationException();

            // TODO implement
        }

        public void set(T o) {
            if (_readOnly) {
                throw new IllegalStateException(ILLEGAL_ACCESS);
            }

            throw new UnsupportedOperationException();

            // TODO implement
        }
    }
}
