/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip;

import java.util.ListIterator;

import javax.servlet.sip.Address;


/**
 * This help class wraps <code>ListIterator</code>, to protected
 * the system header to be modified.
 *
 * @author eraayaz
 * @since 2005-jun-09
 */
public class SipListIterator<E> implements ListIterator<E> {
    private ListIterator<E> listIterator = null;
    private boolean systemHeader = false;

    public SipListIterator(ListIterator<E> listIterator, boolean systemHeader) {
        this.listIterator = listIterator;
        this.systemHeader = systemHeader;
    }

    public boolean hasNext() {
        return listIterator.hasNext();
    }

    public E next() {
        return listIterator.next();
    }

    public boolean hasPrevious() {
        return listIterator.hasPrevious();
    }

    public E previous() {
        return listIterator.previous();
    }

    public int nextIndex() {
        return listIterator.nextIndex();
    }

    public int previousIndex() {
        return listIterator.previousIndex();
    }

    public void remove() {
        if (systemHeader) {
            throw new IllegalStateException("Must not alter the System Header");
        }

        listIterator.remove();
    }

    public void set(E o) {
        if (systemHeader) {
            throw new IllegalStateException("Must not alter the System Header");
        }

        if (!(o instanceof Address)) {
            throw new IllegalArgumentException(
                "Attempt to set object that is not javax.servlet.sip.Address");
        }

        listIterator.set(o);
    }

    public void add(E o) {
        if (systemHeader) {
            throw new IllegalStateException("Must not alter the System Header");
        }

        if (!(o instanceof Address)) {
            throw new IllegalArgumentException(
                "Attempt to add object that is not javax.servlet.sip.Address");
        }

        listIterator.add(o);
    }
}
