/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.config.ConvergedContext;
import com.ericsson.ssa.dd.SipApplicationListeners;
import com.ericsson.ssa.sip.PathNode.Type;
import com.ericsson.ssa.sip.timer.ServletTimerImpl;

import java.io.Serializable;

import javax.servlet.sip.Address;
import javax.servlet.sip.TimerListener;


/**
 * Interface to a session manager responsible for managing the SipSession
 * and SipApplicationSession instances of a converged context.
 *
 * @author jluehe
 */
public interface SipSessionManager {
    /**
     * Associates the given ConvergedContext with this SipSessionManager.
     *
     * @param context The ConvergedContext with which to associate this
     * SipSessionManager
     */
    public void setContext(ConvergedContext context);

    /**
     * Gets the ConvergedContext with which this SipSessionManager has been
     * associated.
     *
     * @return The ConvergedContext with which this SipSessionManager has
     * been associated.
     */
    public ConvergedContext getContext();

    /**
     * Creates a new SipApplicationSession.
     *
     * @param sipApplicationListeners The SipApplicationListeners whose
     * SipApplicationSessionListeners need to be notified of the session
     * creation
     *
     * @return The new SipApplicationSession
     */
    public SipApplicationSessionImpl createSipApplicationSession(
        SipApplicationListeners sipApplicationListeners);

    /**
     * Creates a new SipApplicationSession with the given id.
     *
     * @param id The id to assign to the new SipApplicationSession
     * @param sipApplicationListeners The SipApplicationListeners whose
     * SipApplicationSessionListeners need to be notified of the session
     * creation
     *
     * @return The new SipApplicationSession
     */
    public SipApplicationSessionImpl createSipApplicationSession(String id,
        SipApplicationListeners sipApplicationListeners);

    /**
     * Gets the SipApplicationSession with the given id.
     *
     * @return The SipApplicationSession with the given id, or null if not
     * found
     */
    public SipApplicationSessionImpl findSipApplicationSession(String id);

    /**
     * Removes the given SipApplicationSession from this session manager.
     *
     * @param appSession The SipApplicationSession to be removed
     */
    public void removeSipApplicationSession(SipApplicationSessionImpl appSession);

    /**
     * Creates a new SipSession and adds it to the given SipApplicationSession.
     *
     * @param set
     * @param to
     * @param appSession
     * @param handler
     *
     * @return The new SipSession
     */
    public SipSessionDialogImpl createSipSession(DialogSet set, Address to,
        SipApplicationSessionImpl appSession, String handler);

    /**
     * Creates a new SipSession and adds it to the given SipApplicationSession.
     *
     * @param set
     * @param to
     * @param appSession
     * @param handler
     * @type type
     *
     * @return The new SipSession
     */
    public SipSessionDialogImpl createSipSession(DialogSet set, Address to,
        SipApplicationSessionImpl appSession, String handler, Type type);

    /**
     * Gets the SipSession with the given id.
     *
     * @return The SipSession with the given id, or null if not found
     */
    public SipSessionDialogImpl findSipSession(String id);

    /**
     * Removes the given SipSession from this session manager.
     *
     * The SipSession is also removed from its SipApplicationSession parent,
     * if it had been attached to any.
     *
     * @param sipSession The SipSession to remove
     */
    public void removeSipSession(SipSessionDialogImpl sipSession);

    /**
     * Creates a new ServletTimer.
     *
     * @return The new ServletTimer
     */
    public ServletTimerImpl createServletTimer(SipApplicationSessionImpl sas,
        Serializable info, long delay, TimerListener listener);

    /**
     * Creates a new ServletTimer.
     *
     * @return The new ServletTimer
     */
    public ServletTimerImpl createServletTimer(SipApplicationSessionImpl sas,
        Serializable info, long delay, boolean fixedDelay, long period,
        TimerListener listener);

    /**
     * Gets the ServletTimer with the given id.
     *
     * @return The ServletTimer with the given id, or null if not found
     */
    public ServletTimerImpl findServletTimer(String id);

    /**
     * Removes the given ServletTimer.
     *
     * @param timer The ServletTimer to be removed
     */
    public void removeServletTimer(ServletTimerImpl timer);

    /**
     * Gets the name of the instance.on which this session manager resides.
     *
     * @return The name of the instance on which this session manager
     * resides
     */
    public String getInstanceName();

    /**
     * Gets the persistence type of this session manager.
     */
    public String getPersistenceType();

    /**
     * @return True if this session manager should participate in a repair
     * during failure, and false otherwise
     */
    public boolean isRepairDuringFailure();

    /**
     * @return The application id of this session manager
     */
    public String getApplicationId();
}
