/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip;

import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;

import javax.servlet.sip.URI;


/**
 * @author epetstr
 * The purpose of this class is to Internally be able to handle
 * SipURI and TelUrl the same (when applicable)
 */
public abstract class URIImpl implements URI {
    public static final String LOOSE_ROUTE_PARAM = "lr";
    public static final String FRAGID_PARAM = "fid";
    private static final Logger _logger = Logger.getLogger("SipContainer");
    protected ParameterByteMap _parameters = new ParameterByteMap(';');

    public URIImpl() {
    }

    public String getParameter(String param) {
        if (_parameters == null) {
            return null;
        }

        return _parameters.get(param);
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.sip.SipURI#getLrParam()
     */
    public boolean getLrParam() {
        String v = getParameter(LOOSE_ROUTE_PARAM);

        return (v != null) && (v.equals("") || v.equals("on"));

        // FIXME ... special case of iptel proxy router.
        // Should we support it really?
        // See newsgroup thread.
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.sip.URI#getScheme()
     */
    public String getScheme() {
        throw new RuntimeException("Should be implemented by subclasses");
    }

    public void setParameter(String name, String value) {
        if (_parameters == null) {
            _parameters = new ParameterByteMap(';');
        }

        _parameters.put(name, value);
    }

    public void removeParameter(String name) {
        if (_parameters != null) {
            _parameters.remove(name);
        }
    }

    public Iterator<String> getParameterNames() {
        if (_parameters == null) {
            return Collections.EMPTY_LIST.iterator();
        }

        return _parameters.getKeys();
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.sip.URI#isSipURI()
     */
    public boolean isSipURI() {
        return true;
    }

    /*
     * (non-Javadoc)
     *
     * @see java.lang.Object#clone()
     */
    public Object clone() {
        throw new RuntimeException("Should be implemented by subclasses");
    }

    public int getFragmentId() {
        String id = getParameter(FRAGID_PARAM);

        if (id == null) {
            return DialogFragment.DEFAULT_FRAGMENT_ID;
        } else {
            try {
                return Integer.parseInt(id);
            } catch (NumberFormatException nfx) {
                // Should not happen. We return an impossible value.
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE,
                        "parsing of fragment-id failed, substituting " +
                        DialogFragment.BAD_FRAGMENT_ID);
                }

                return DialogFragment.BAD_FRAGMENT_ID;
            }
        }
    }
}
