/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip;

import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;


/**
 * This is is a utility for accessing common parts in URI subclasses, that are
 * not specified in the URI interface.
 */
public class UriUtil {
    /**
     * Sets the specified parameter of the URI in the request to the specified
     * value.
     *
     * @param uri
     *                the URI
     * @param name
     *                parameter name
     * @param value
     *                parameter value
     */
    public static void setParameter(URI uri, String name, String value) {
        if (uri instanceof SipURI) {
            SipURI sipUri = (SipURI) uri;
            sipUri.setParameter(name, value);
        } else {
            TelURLImpl telUrl = (TelURLImpl) uri;
            telUrl.setParameter(name, value);
        }
    }

    /**
     * Remove the specified parameter of the URI in the request.
     *
     * @param uri
     *                the URI
     * @param name
     *           the parameter name
     * @return the value of the removed parameter (or null if parameter does not
     *         exist)
     */
    public static String removeParameter(URI uri, String name) {
        if (uri instanceof SipURI) {
            SipURI sipUri = (SipURI) uri;
            String value = sipUri.getParameter(name);
            sipUri.removeParameter(name);

            return value;
        } else {
            TelURLImpl telUrl = (TelURLImpl) uri;
            String value = telUrl.getParameter(name);
            telUrl.removeParameter(name);

            return value;
        }
    }

    /**
     * Gets the value of the specified parameter of the URI in the request.
     *
     * @param uri
     *                the URI
     * @param name
     *           parameter name
     */
    public static String getParameter(URI uri, String name) {
        if (uri instanceof SipURI) {
            SipURI sipUri = (SipURI) uri;

            return sipUri.getParameter(name);
        } else {
            TelURLImpl telUrl = (TelURLImpl) uri;

            return telUrl.getParameter(name);
        }
    }
}
