/**
 * Copyright (c) Ericsson AB, 2007.
 *
 * All Rights Reserved. Reproduction in whole or in part is prohibited
 * without the written consent of the copyright owner.
 *
 * ERICSSON MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. ERICSSON SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
package com.ericsson.ssa.sip;


/**
 * Support JSR289 (SSA1.1), 10.2.3 Sending Responses.
 *
 * Applications may generate informational responses of their own before or
 * during a proxying operation.
 */
public class VirtualProxyBranchImpl extends ProxyBranchImpl {
    public VirtualProxyBranchImpl(ProxyImpl p, SipServletRequestImpl request) {
        super(p, request);
    }

    public void proxyTo() throws IllegalStateException {
        // let it point back to this.
        setParent(this);
        prepareProxyTo();
    }

    @Override
    public boolean getParallel() {
        return true;
    }

    @Override
    public boolean isStarted() {
        return true;
    }

    @Override
    public boolean getRecurse() {
        return false;
    }

    @Override
    public boolean doInitialResponse(SipServletResponseImpl resp,
        ProxyContext pc) {
        super.doInitialResponse(resp, pc);

        return true;
    }
}
