/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip.dns;

import org.xbill.DNS.NAPTRRecord;

import java.util.Comparator;


public class NaptrComparator implements Comparator {
    private static final int compBEFORE = -1;
    private static final int compEQUAL = 0;
    private static final int compAFTER = 1;

    public NaptrComparator() {
    }

    public int compare(Object o1, Object o2) {
        NAPTRRecord rec1 = (NAPTRRecord) o1;
        NAPTRRecord rec2 = (NAPTRRecord) o2;
        int comparison = compareOrder(rec1, rec2);

        if (comparison != compEQUAL) {
            return comparison;
        }

        return comparePreference(rec1, rec2);
    }

    public int compareOrder(NAPTRRecord rec1, NAPTRRecord rec2) {
        return ((rec1.getOrder() < rec2.getOrder()) ? compBEFORE
                                                    : ((rec1.getOrder() == rec2.getOrder())
        ? compEQUAL : compAFTER));
    }

    public int comparePreference(NAPTRRecord rec1, NAPTRRecord rec2) {
        return ((rec1.getPreference() < rec2.getPreference()) ? compBEFORE
                                                              : ((rec1.getPreference() == rec2.getPreference())
        ? compEQUAL : compAFTER));
    }

    public boolean equals(Object obj) {
        return equals(obj);
    }
}
