/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip.timer;

import com.ericsson.ssa.sip.SipStore;

import java.io.IOException;


/**
 * Interface to a persistent store for ServletTimers.
 *
 * @author jluehe
 */
public interface ServletTimerStore extends SipStore {
    /**
     * Loads and returns the ServletTimer with the given id from
     * this store.
     *
     * @param id The id of the ServletTimer to load
     *
     * @return The ServletTimer with the given id, or null if not
     * found
     *
     * @throws IOException
     */
    public ServletTimerImpl load(String id) throws IOException;

    /**
     * Saves the given ServletTimer to this store.
     *
     * If a ServletTimer with the same id already exists in this
     * store, it will be replaced.
     *
     * @param sas The ServletTimer to be saved
     *
     * @exception IOException
     */
    public void save(ServletTimerImpl timer) throws IOException;

    /**
     * Removes the ServletTimer with the given id from this store.
     *
     * @param id The id of the ServletTimer to be removed
     *
     * @exception IOException
     */
    public void remove(String id) throws IOException;

    /**
     * Removes all ServletTimers from this store.
     */
    public void clear() throws IOException;
}
