/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip.transaction;

import com.ericsson.ssa.container.startup.PerformanceMBeanListener;
import com.ericsson.ssa.sip.Dispatcher;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;


/**
 * @author ekrigro TODO To change the template for this generated type comment
 *         go to Window - Preferences - Java - Code Style - Code Templates
 */
public abstract class ServerTransaction extends Transaction
    implements Dispatcher {
    protected SipServletResponseImpl _response;

    /**
     * @param state
     * @param req
     */
    public ServerTransaction(String id, TransactionState state,
        SipServletRequestImpl req) {
        super(id, state, req);

        if (PerformanceMBeanListener.isEnabled()) {
            _transactionManager.incrEasSipServerTransactions();
        }
    }

    // Dummy
    public void dispatch(SipServletRequestImpl req) {
    }

    protected synchronized void terminate() {
        super.terminate();
        // must use the external lock of the server transaction...
        _transactionManager.remove(this);
        _response = null;
    }

    abstract boolean handle(SipServletRequestImpl req);

    abstract void handleCancel(ServerTransaction st);
}
