/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.utils;

import java.io.IOException;
import java.io.OutputStream;


/* TODO Add imports */
/**
 * TODO Add comments (class description)
 *
 *
 * @author edtugdi
 * @since 2005-maj-11
 *
 */
public class StringOutputStream extends OutputStream {
    private StringBuffer buf;
    private boolean closed;

    public StringOutputStream(StringBuffer wsource) {
        buf = wsource;
    }

    public void close() throws IOException {
        if (!closed) {
            closed = true;
            super.close();
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (closed) {
            throw new IOException("The Output stream has been closed");
        }

        buf.append((byte) b);
    }
}
