/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.util.os.linux;

import com.ericsson.util.os.OSUtilSunspecific;

import java.io.FileInputStream;
import java.io.IOException;

import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;


/**
 * OS util class for the linux operating system.
 *
 * @author ehsroha
 * @since 2006-mar-30
 */
public class OSUtilLinux extends OSUtilSunspecific {
    private static final Logger _log = (Logger) Logger.getLogger("SipContainer");
    private Double _lastIdle = 0.0;
    private Double _lastTime = 0.0;
    private FileInputStream _file = null;
    private long _lastVisit = 0;
    private int _savedBusy = 0;

    public OSUtilLinux() {
    }

    public String getInfo() {
        return getClass().getName() + ": linux operating system extension";
    }

    public int cpuBusy() {
        long now = System.currentTimeMillis();

        if ((now - _lastVisit) > 1000) {
            _lastVisit = now;

            try {
                byte[] buf = new byte[1024];

                // read /proc/uptime
                if (_file == null) {
                    _file = new FileInputStream("/proc/uptime");
                }

                if (_file.markSupported()) {
                    _file.reset();
                    _file.read(buf);
                } else {
                    _file.read(buf);
                    _file.close();
                    _file = null;
                }

                // get first line an split in to piece
                String[] b = new String(buf).split("[ ]+");

                // value [0] contains uptime
                // value [1] contains idle
                Double new_time = Double.parseDouble(b[0]);
                Double new_idle = Double.parseDouble(b[1]);

                if (_lastTime == 0.0) {
                    _lastTime = new_time;
                    _lastIdle = new_idle;
                    _savedBusy = 0; // overkill :-)

                    return _savedBusy;
                } else {
                    Double busyPercent = 100 -
                        ((100.0 * (new_idle - _lastIdle)) / (new_time -
                        _lastTime));

                    // to make values withing 0.0 >= percent >= 100.0 :-)
                    // only needed if this method is called VERY frequently (i.e.
                    // more than once a second)
                    if (busyPercent < 0) {
                        busyPercent = 0.0;
                    }

                    if (busyPercent > 100) {
                        busyPercent = 100.0;
                    }

                    _lastTime = new_time;
                    _lastIdle = new_idle;
                    _savedBusy = busyPercent.intValue();

                    return _savedBusy;
                }
            } catch (IOException e) {
                _log.log(Level.WARNING, "Error while reading cpu information.",
                    e);

                // return old value...
                return _savedBusy;
            }
        } else {
            return _savedBusy;
        }
    }
}
