/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package javax.servlet.sip;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;


public interface SipServletResponse extends ServletResponse, SipServletMessage {
    public static final int SC_TRYING = 100;
    public static final int SC_RINGING = 180;
    public static final int SC_CALL_BEING_FORWARDED = 181;
    public static final int SC_CALL_QUEUED = 182;
    public static final int SC_SESSION_PROGRESS = 183;
    public static final int SC_OK = 200;
    public static final int SC_ACCEPTED = 202;
    public static final int SC_MULTIPLE_CHOICES = 300;
    public static final int SC_MOVED_PERMANENTLY = 301;
    public static final int SC_MOVED_TEMPORARILY = 302;
    public static final int SC_USE_PROXY = 305;
    public static final int SC_ALTERNATIVE_SERVICE = 380;
    public static final int SC_BAD_REQUEST = 400;
    public static final int SC_UNAUTHORIZED = 401;
    public static final int SC_PAYMENT_REQUIRED = 402;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_NOT_FOUND = 404;
    public static final int SC_METHOD_NOT_ALLOWED = 405;
    public static final int SC_NOT_ACCEPTABLE = 406;
    public static final int SC_PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int SC_REQUEST_TIMEOUT = 408;
    public static final int SC_GONE = 410;
    public static final int SC_CONDITIONAL_REQUEST_FAILED = 412;
    public static final int SC_REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int SC_REQUEST_URI_TOO_LONG = 414;
    public static final int SC_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int SC_UNSUPPORTED_URI_SCHEME = 416;
    public static final int SC_BAD_EXTENSION = 420;
    public static final int SC_EXTENSION_REQUIRED = 421;
    public static final int SC_SESSION_INTERVAL_TOO_SMALL = 422;
    public static final int SC_INTERVAL_TOO_BRIEF = 423;
    public static final int SC_PROVIDE_REFERER_IDENTITY = 429;
    public static final int SC_TEMPORARLY_UNAVAILABLE = 480;
    public static final int SC_CALL_LEG_DONE = 481;
    public static final int SC_LOOP_DETECTED = 482;
    public static final int SC_TOO_MANY_HOPS = 483;
    public static final int SC_ADDRESS_INCOMPLETE = 484;
    public static final int SC_AMBIGUOUS = 485;
    public static final int SC_BUSY_HERE = 486;
    public static final int SC_REQUEST_TERMINATED = 487;
    public static final int SC_NOT_ACCEPTABLE_HERE = 488;
    public static final int SC_BAD_EVENT = 489;
    public static final int SC_REQUEST_PENDING = 491;
    public static final int SC_UNDECIPHERABLE = 493;
    public static final int SC_SECURITY_AGREEMENT_REQUIRED = 494;
    public static final int SC_SERVER_INTERNAL_ERROR = 500;
    public static final int SC_NOT_IMPLEMENTED = 501;
    public static final int SC_BAD_GATEWAY = 502;
    public static final int SC_SERVICE_UNAVAILABLE = 503;
    public static final int SC_SERVER_TIMEOUT = 504;
    public static final int SC_VERSION_NOT_SUPPORTED = 505;
    public static final int SC_MESSAGE_TOO_LARGE = 513;
    public static final int SC_PRECONDITION_FAILURE = 580;
    public static final int SC_BUSY_EVERYWHERE = 600;
    public static final int SC_DECLINE = 603;
    public static final int SC_DOES_NOT_EXIT_ANYWHERE = 604;
    public static final int SC_NOT_ACCEPTABLE_ANYWHERE = 606;

    SipServletRequest getRequest();

    int getStatus();

    void setStatus(int responseCode);

    void setStatus(int responseCode, String reasonPhrase);

    String getReasonPhrase();

    ServletOutputStream getOutputStream() throws IOException;

    PrintWriter getWriter() throws IOException;

    Proxy getProxy();

    void sendReliably() throws Rel100Exception;

    void send() throws IOException;

    SipServletRequest createAck();

    SipServletRequest createPrack() throws Rel100Exception;

    String[] getChallengeRealm();
}
