/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.annotation;

import com.sun.jsftemplating.annotation.HandlerAP;
import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.apt.AnnotationProcessorListener;
import com.sun.mirror.apt.AnnotationProcessors;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.apt.RoundCompleteEvent;
import com.sun.mirror.apt.RoundCompleteListener;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerAPFactory
implements AnnotationProcessorFactory,
RoundCompleteListener {
    private boolean _setup = false;
    private PrintWriter _writer = null;
    private static final Collection<String> _supportedAnnotationTypes = Arrays.asList("com.sun.jsftemplating.annotation.Handler", "com.sun.jsftemplating.annotation.HandlerInput", "com.sun.jsftemplating.annotation.HandlerOutput");
    private static final Collection<String> _supportedOptions = Collections.emptySet();
    public static final String HANDLER_FILE = "META-INF/jsftemplating/Handler.map";

    public Collection<String> supportedAnnotationTypes() {
        return _supportedAnnotationTypes;
    }

    public Collection<String> supportedOptions() {
        return _supportedOptions;
    }

    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> types, AnnotationProcessorEnvironment env) {
        AnnotationProcessor processor = AnnotationProcessors.NO_OP;
        if (types != null && types.size() > 0 && this.setup(env)) {
            processor = new HandlerAP(types, env, this._writer);
        }
        return processor;
    }

    private boolean setup(AnnotationProcessorEnvironment env) {
        if (this._setup) {
            return true;
        }
        env.addListener((AnnotationProcessorListener)this);
        try {
            this._writer = this.getHandlerMapWriter(env);
        }
        catch (IOException ex) {
            StringWriter buf = new StringWriter();
            ex.printStackTrace(new PrintWriter(buf));
            env.getMessager().printError("Unable to write 'META-INF/jsftemplating/Handler.map' file while processing @Handler annotation: " + buf.toString());
            return false;
        }
        this._setup = true;
        return true;
    }

    private PrintWriter getHandlerMapWriter(AnnotationProcessorEnvironment env) throws IOException {
        PrintWriter writer = null;
        ClassLoader cl = this.getClass().getClassLoader();
        URL url = null;
        Enumeration<URL> urls = cl.getResources(HANDLER_FILE);
        while (urls.hasMoreElements() && writer == null) {
            url = urls.nextElement();
            if (url == null || !new File(url.getFile()).canRead()) continue;
            writer = new PrintWriter(new FileOutputStream(url.getFile(), true));
        }
        if (writer == null) {
            writer = env.getFiler().createTextFile(Filer.Location.CLASS_TREE, "", new File(HANDLER_FILE), (String)null);
        }
        return writer;
    }

    public void roundComplete(RoundCompleteEvent event) {
        if (event.getRoundState().finalRound() && this._setup) {
            this._writer.close();
        }
    }
}

