/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.netbeans.nbbuild.UpdateTracking;

public class NbMerge
extends Task {
    private File dest;
    private Vector modules = new Vector();
    private Vector buildmodules = new Vector();
    private Vector fixedmodules = new Vector();
    private Vector buildfixedmodules = new Vector();
    private Vector failedmodules = new Vector();
    private Vector builtmodules = new Vector();
    private Vector mergemodules = new Vector();
    private Vector builttargets = new Vector();
    private String targetprefix = "all-";
    private List topdirs = new ArrayList();
    private List suppress = new LinkedList();
    private boolean failonerror = true;
    private boolean mergedependentmodules = false;
    private String dummyName;
    private Target dummy;
    private Hashtable targets;
    private String builtmodulesproperty = "";

    public void setDest(File f) {
        this.dest = f;
    }

    public void setFailOnError(boolean b) {
        this.failonerror = b;
    }

    public void setBuiltModulesProperty(String s) {
        this.builtmodulesproperty = s;
    }

    public void setMergeDependentModules(boolean b) {
        this.mergedependentmodules = b;
    }

    public void setFixedModules(String s) {
        StringTokenizer tok = new StringTokenizer(s, ", ");
        this.fixedmodules = new Vector();
        while (tok.hasMoreTokens()) {
            this.fixedmodules.addElement(tok.nextToken());
        }
    }

    public void setModules(String s) {
        StringTokenizer tok = new StringTokenizer(s, ", ");
        this.modules = new Vector();
        while (tok.hasMoreTokens()) {
            this.modules.addElement(tok.nextToken());
        }
    }

    public void setTargetprefix(String s) {
        this.targetprefix = s;
    }

    public void setTopdir(File t) {
        this.topdirs.add(t);
    }

    public Topdir createTopdir() {
        NbMerge nbMerge = this;
        if (nbMerge == null) {
            throw null;
        }
        return nbMerge.new Topdir();
    }

    public Suppress createSuppress() {
        NbMerge nbMerge = this;
        if (nbMerge == null) {
            throw null;
        }
        Suppress s = nbMerge.new Suppress();
        this.suppress.add(s);
        return s;
    }

    private void FixedModulesBuild() throws BuildException {
        this.dummy = new Target();
        this.dummyName = "nbmerge-" + this.target.getName();
        this.targets = ((ProjectComponent)this).project.getTargets();
        while (this.targets.contains(this.dummyName)) {
            this.dummyName = this.dummyName + "-x";
        }
        this.dummy.setName(this.dummyName);
        int i = 0;
        while (i < this.buildfixedmodules.size()) {
            String fixedmodule = (String)this.buildfixedmodules.elementAt(i);
            this.dummy.addDependency(this.targetprefix + fixedmodule);
            ++i;
        }
        ((ProjectComponent)this).project.addTarget(this.dummy);
        ((ProjectComponent)this).project.setProperty("fixedmodules-built", "1");
        Vector fullList = ((ProjectComponent)this).project.topoSort(this.dummyName, this.targets);
        Vector doneList = ((ProjectComponent)this).project.topoSort(this.getOwningTarget().getName(), this.targets);
        ArrayList todo = new ArrayList(fullList.subList(0, fullList.indexOf(this.dummy)));
        todo.removeAll(doneList.subList(0, doneList.indexOf(this.getOwningTarget())));
        Iterator targit = todo.iterator();
        this.log("Going to execute targets " + todo);
        while (targit.hasNext()) {
            Target nexttargit = (Target)targit.next();
            String targetname = nexttargit.getName();
            if (this.builttargets.indexOf(targetname) >= 0) continue;
            System.out.println("");
            System.out.println(targetname + ":");
            nexttargit.execute();
            this.builttargets.addElement(targetname);
        }
        this.builtmodules.addAll(this.buildfixedmodules);
        this.log("fixedmodules=" + this.buildfixedmodules, 4);
        this.log("builtmodules=" + this.builtmodules, 3);
    }

    private void ModulesBuild() throws BuildException {
        if (!this.failonerror) {
            int i = 0;
            while (i < this.buildmodules.size()) {
                String module = (String)this.buildmodules.elementAt(i);
                this.dummy = new Target();
                this.dummyName = "nbmerge-" + this.target.getName() + "-" + module;
                while (this.targets.contains(this.dummyName)) {
                    this.dummyName = this.dummyName + "-x";
                }
                this.dummy.setName(this.dummyName);
                this.dummy.addDependency(this.targetprefix + module);
                ((ProjectComponent)this).project.addTarget(this.dummy);
                Vector fullList = ((ProjectComponent)this).project.topoSort(this.dummyName, this.targets);
                Vector doneList = ((ProjectComponent)this).project.topoSort(this.getOwningTarget().getName(), this.targets);
                ArrayList todo = new ArrayList(fullList.subList(0, fullList.indexOf(this.dummy)));
                todo.removeAll(doneList.subList(0, doneList.indexOf(this.getOwningTarget())));
                Iterator targit = todo.iterator();
                try {
                    while (targit.hasNext()) {
                        Target nexttargit = (Target)targit.next();
                        String targetname = nexttargit.getName();
                        if (this.builttargets.indexOf(targetname) >= 0) continue;
                        System.out.println("");
                        System.out.println(targetname + ":");
                        nexttargit.execute();
                        this.builttargets.addElement(targetname);
                    }
                    this.builtmodules.addElement(module);
                }
                catch (BuildException BE) {
                    this.log(BE.toString(), 1);
                    BE.printStackTrace();
                    this.failedmodules.addElement(module);
                }
                ++i;
            }
            this.log("builtmodules=" + this.builtmodules, 3);
            this.log("failedmodules=" + this.failedmodules, 3);
        }
    }

    public void execute() throws BuildException {
        if (this.topdirs.isEmpty()) {
            throw new BuildException("You must set at least one topdir attribute", this.location);
        }
        this.buildfixedmodules.addAll(this.fixedmodules);
        this.buildmodules.addAll(this.modules);
        if (this.modules.size() > 0 && this.fixedmodules.size() == 0 && !this.failonerror) {
            this.log("Unable to build without fixedmodules set", 1);
            this.log("Swapping modules list with fixedmodules list", 1);
            this.buildfixedmodules.addAll(this.modules);
            this.buildmodules.removeAllElements();
        }
        if (this.failonerror && this.modules.size() > 0) {
            this.buildfixedmodules.addAll(this.modules);
            this.buildmodules.removeAllElements();
        }
        this.FixedModulesBuild();
        this.ModulesBuild();
        this.DataMerge();
        if (this.builtmodules.size() > 0) {
            this.log("builtmodules=" + this.builtmodules);
            this.log("builttargets=" + this.builttargets);
            if (this.failedmodules.size() > 0) {
                this.log("SOME MODULES FAILED TO BUILD, BUT THEIR BuildException WAS CAUGHT.", 1);
                this.log("failedmodules=" + this.failedmodules, 1);
            }
            if (this.mergemodules.size() > 0 && this.builtmodulesproperty.length() > 0) {
                Vector setmodules = new Vector();
                setmodules.addAll(this.mergemodules);
                setmodules.removeAll(this.fixedmodules);
                if (!this.modules.containsAll(setmodules) || !setmodules.containsAll(this.modules)) {
                    String bm = setmodules.toString();
                    if ((bm = bm.substring(1, bm.length() - 1)).length() > 0) {
                        this.log("Setting property \"" + this.builtmodulesproperty + "\" to new value " + bm);
                        ((ProjectComponent)this).project.setUserProperty(this.builtmodulesproperty, bm);
                    }
                }
            }
        } else {
            throw new BuildException("No modules were built", this.location);
        }
    }

    private void DataMerge() throws BuildException {
        LinkedList<String> suppressedlocales = new LinkedList<String>();
        Iterator it = this.suppress.iterator();
        while (it.hasNext()) {
            Suppress s = (Suppress)it.next();
            if (s.iftest != null && ((ProjectComponent)this).project.getProperty(s.iftest) == null || s.unlesstest != null && ((ProjectComponent)this).project.getProperty(s.unlesstest) != null) continue;
            this.log("Suppressing locale: " + s.locale);
            suppressedlocales.add(s.locale);
        }
        this.mergemodules = new Vector();
        this.mergemodules.addAll(this.builtmodules);
        if (this.mergedependentmodules) {
            int i = 0;
            while (i < this.builttargets.size()) {
                String module;
                String target = (String)this.builttargets.elementAt(i);
                if (target.startsWith(this.targetprefix) && this.mergemodules.indexOf(module = target.substring(this.targetprefix.length())) < 0) {
                    this.mergemodules.addElement(module);
                }
                ++i;
            }
        }
        int j = 0;
        while (j < this.topdirs.size()) {
            File topdir = (File)this.topdirs.get(j);
            int i = 0;
            while (i < this.mergemodules.size()) {
                String module = (String)this.mergemodules.elementAt(i);
                File netbeans = new File(new File(topdir, module), "netbeans");
                if (!netbeans.exists()) {
                    this.log("Build product dir " + netbeans + " does not exist, skipping...", 1);
                } else {
                    Copy copy = (Copy)((ProjectComponent)this).project.createTask("copy");
                    FileSet fs = new FileSet();
                    fs.setDir(netbeans);
                    it = suppressedlocales.iterator();
                    while (it.hasNext()) {
                        String locale = (String)it.next();
                        fs.createExclude().setName("**/*_" + locale);
                        fs.createExclude().setName("**/*_" + locale + ".*");
                        fs.createExclude().setName("**/*_" + locale + "/");
                    }
                    copy.addFileset(fs);
                    copy.setTodir(this.dest);
                    copy.setIncludeEmptyDirs(true);
                    copy.init();
                    copy.setLocation(this.location);
                    copy.execute();
                }
                ++i;
            }
            ++j;
        }
        this.log("mergedmodules=" + this.mergemodules);
        it = suppressedlocales.iterator();
        UpdateTracking tr = new UpdateTracking(this.dest.getAbsolutePath());
        this.log(this.dest.getAbsolutePath());
        while (it.hasNext()) {
            String locale = (String)it.next();
            tr.removeLocalized(locale);
        }
    }

    public class Topdir {
        public void setPath(File t) {
            NbMerge.this.topdirs.add(t);
        }
    }

    public class Suppress {
        String locale;
        String iftest;
        String unlesstest;

        public void setLocale(String l) {
            this.locale = l;
        }

        public void setIf(String p) {
            this.iftest = p;
        }

        public void setUnless(String p) {
            this.unlesstest = p;
        }
    }
}

