/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.compilers;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Apt;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class AptCompilerAdapter
extends DefaultCompilerAdapter {
    private static final int APT_COMPILER_SUCCESS = 0;
    public static final String APT_ENTRY_POINT = "com.sun.tools.apt.Main";
    public static final String APT_METHOD_NAME = "process";

    protected Apt getApt() {
        return (Apt)this.getJavac();
    }

    static void setAptCommandlineSwitches(Apt apt, Commandline commandline) {
        File file;
        Path path;
        String string;
        if (apt.isNoCompile()) {
            commandline.createArgument().setValue("-nocompile");
        }
        if ((string = apt.getFactory()) != null) {
            commandline.createArgument().setValue("-factory");
            commandline.createArgument().setValue(string);
        }
        if ((path = apt.getFactoryPath()) != null) {
            commandline.createArgument().setValue("-factorypath");
            commandline.createArgument().setPath(path);
        }
        if ((file = apt.getPreprocessDir()) != null) {
            commandline.createArgument().setValue("-s");
            commandline.createArgument().setFile(file);
        }
        Vector vector = apt.getOptions();
        Enumeration enumeration = vector.elements();
        StringBuffer stringBuffer = null;
        while (enumeration.hasMoreElements()) {
            Apt.Option option = (Apt.Option)enumeration.nextElement();
            stringBuffer = new StringBuffer();
            stringBuffer.append("-A").append(option.getName());
            if (option.getValue() != null) {
                stringBuffer.append("=").append(option.getValue());
            }
            commandline.createArgument().setValue(stringBuffer.toString());
        }
    }

    protected void setAptCommandlineSwitches(Commandline commandline) {
        Apt apt = this.getApt();
        AptCompilerAdapter.setAptCommandlineSwitches(apt, commandline);
    }

    public boolean execute() throws BuildException {
        this.attributes.log("Using apt compiler", 3);
        Commandline commandline = this.setupModernJavacCommand();
        this.setAptCommandlineSwitches(commandline);
        try {
            Class<?> clazz = Class.forName(APT_ENTRY_POINT);
            Object obj = clazz.newInstance();
            Method[] methodArray = clazz.getMethods();
            Method method = clazz.getMethod(APT_METHOD_NAME, new String[0].getClass());
            int n = (Integer)method.invoke(obj, new Object[]{commandline.getArguments()});
            return n == 0;
        }
        catch (BuildException buildException) {
            throw buildException;
        }
        catch (Exception exception) {
            throw new BuildException("Error starting apt compiler", (Throwable)exception, this.location);
        }
    }
}

