/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.admin.clbadmin;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigContextEventListener;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.ConvergedLoadBalancer;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.logging.ee.EELogDomains;

import org.jvnet.glassfish.comms.admin.clbadmin.ClbConfigPublisher;

import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * This class listens to the element change event
 *
 * @author Vijaya Gadhamsetty
 */
public class ClbAdminEventListener implements ConfigContextEventListener {
    
    private static Logger _logger = Logger.getLogger(EELogDomains.EE_ADMIN_LOGGER);
    
    /**
     * Default constructor.
     */
    public ClbAdminEventListener() {
    }

    /**
     * before config add, delete, set, update or flush. type is in ev
     */
    public void postAccessNotification(ConfigContextEvent ev) {
    }

    /**
     * after config add, delete, set, update or flush. type is in ev
     */
    public void preChangeNotification(ConfigContextEvent ev) {
    }

    /**
     * before config add, delete, set, update or flush. type is in ev
     */
    public void preAccessNotification(ConfigContextEvent ev) {
    }

    /**
     * after config add, delete, set, update or flush. type is in ev
     * applies the changes to the applicable load balancers
     */
    public void postChangeNotification(ConfigContextEvent ev) {
        String choice = ev.getChoice();

        if (choice == null) {
            return;
        }

        if (!choice.equals("ADD") && !choice.equals("DELETE") &&
                !choice.equals("UPDATE") && !choice.equals("SET")) {
            return;
        }

        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext()
                                            .getAdminConfigContext();
            Configs configs = ((Domain) ctx.getRootConfigBean()).getConfigs();

            if (configs == null) {
                return;
            }

            Config[] cfgs = configs.getConfig();

            if (cfgs == null) {
                return;
            }

            for (com.sun.enterprise.config.serverbeans.Config cfg : cfgs) {
                if ((cfg == null) || (cfg.getAvailabilityService() == null) ||
                        (cfg.getAvailabilityService().getConvergedLoadBalancer() == null)) {
                    continue;
                } else {
                    ConvergedLoadBalancer clb = cfg.getAvailabilityService()
                                                   .getConvergedLoadBalancer();

                    if (!clb.isAutoCommit()) {
                        continue;
                    }

                    ClbConfigPublisher clbp = new ClbConfigPublisher(ctx,
                            clb.getConvergedLbConfigName(), clb.getName());
                    ClbAdminEventHelper lbAdminEventHelper = new ClbAdminEventHelper(ctx, clbp, clb);
                    if (lbAdminEventHelper.isApplyChangesRequired()) {
                        _logger.log(Level.INFO, "Changes Detected for Converged Load Balancer XML. Publishing it.");
                        String configFileNewValue = clbp.publish(clb.getConfigFile());
    
                        // set the value of config-file in the converged-load-balancer element
                        MBeanServer mbs = AdminService.getAdminService().getAdminContext().getMBeanServer();
                        String[] types = new String[] {(new String[]{}).getClass().getName()};
                        _logger.log(Level.INFO, "Setting the config-file to " + configFileNewValue + 
                                                                                    " through the dottedNameSet MBean");
                        Object[] returnValues = (Object[])mbs.invoke(
                                    new ObjectName("com.sun.appserv:name=dotted-name-get-set,type=dotted-name-support"),
                                    "dottedNameSet",
                                    new Object[] {new String[] {cfg.getName() + ".availability-service.converged-load-balancer.config-file=" + configFileNewValue}},
                                    types);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
