/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.admin.clbadmin.reader.api;


/**
 * Provides cluster information relavant to Load balancer tier.
 *
 * @author Vijaya Gadhamsetty
 */
public interface ClusterReader extends BaseReader {
    /**
     * Get the name of the cluster
     *
     * @return String   name of the cluster
     */
    public String getName() throws LbReaderException;

    /**
     * Get the instance readers in the cluster
     *
     * @return InstanceReader[]   array of instance readers in the cluser
     */
    public InstanceReader[] getInstances() throws LbReaderException;

    /**
     * Returns all the web modules in the cluster
     *
     * @return WebModuleReader[]    array of web module readers in the cluster
     */
    public WebModuleReader[] getWebModules() throws LbReaderException;

    public String getSelfLoadbalance() throws LbReaderException;
}
