/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.admin.clbadmin.reader.impl;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ConvergedLbClusterRef;
import com.sun.enterprise.config.serverbeans.ConvergedLbConfig;
import com.sun.enterprise.config.serverbeans.ConvergedLbConfigs;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;

import com.sun.logging.ee.EELogDomains;

import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.ClusterReader;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.LbReaderException;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.LoadbalancerReader;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.PropertyReader;
import org.jvnet.glassfish.comms.admin.clbadmin.transform.LoadbalancerVisitor;
import org.jvnet.glassfish.comms.admin.clbadmin.transform.Visitor;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * Reader class to get information about load balancer configuration.
 *
 * @author Vijaya Gadhamsetty
 */
public class LoadbalancerReaderImpl implements LoadbalancerReader {
    ConvergedLbConfig _clbConfig = null;
    ConfigContext _ctx = null;

    public LoadbalancerReaderImpl(ConfigContext ctx, ConvergedLbConfig clbConfig) {
        if ((clbConfig == null) || (ctx == null)) {
            throw new IllegalArgumentException("clbconfig null");
        }

        _ctx = ctx;
        _clbConfig = clbConfig;
    }

    //--- READER IMPLEMENTATION -----

    /**
     * Returns properties of the load balancer.
     *
     * @return PropertyReader[]     array of properties
     */
    public PropertyReader[] getProperties() throws LbReaderException {
        // all the attributes as properties
        ElementProperty[] properties = _clbConfig.getElementProperty();
        PropertyReader[] pRdrs = new PropertyReaderImpl[properties.length];

        int i = 0;

        // XXX add all the properties
        for (ElementProperty prop : properties) {
            pRdrs[i++] = new PropertyReaderImpl(_clbConfig, prop.getName());
        }

        return pRdrs;
    }

    /**
     * Returns the cluster info that are load balanced by this LB.
     *
     * @return ClusterReader        array of cluster readers
     */
    public ClusterReader[] getClusters() throws LbReaderException {
        List list = new ArrayList();

        ConvergedLbClusterRef[] clsRefs = _clbConfig.getConvergedLbClusterRef();
        ServerRef[] sRefs = _clbConfig.getServerRef();

        if (((clsRefs == null) || (clsRefs.length == 0)) &&
                ((sRefs == null) || (sRefs.length == 0))) {
            return null;
        }

        ClusterReader cRdr = null;

        for (int i = 0; i < clsRefs.length; i++) {
            cRdr = new ClusterReaderImpl(_ctx,
                    _clbConfig.getConvergedLbClusterRef(i));
            list.add(cRdr);
        }

        for (int j = 0; j < sRefs.length; j++) {
            cRdr = new StandAloneClusterReaderImpl(_ctx,
                    _clbConfig.getServerRef(j));
            list.add(cRdr);
        }

        ClusterReader[] cRdrs = new ClusterReader[list.size()];

        return (ClusterReader[]) list.toArray(cRdrs);
    }

    public String getHttpPolicy() throws LbReaderException {
        return _clbConfig.getConvergedLbPolicy().getHttp();
    }

    public String getSipPolicy() throws LbReaderException {
        return _clbConfig.getConvergedLbPolicy().getSip();
    }

    public String getDcrFile() throws LbReaderException {
        return _clbConfig.getConvergedLbPolicy().getDcrFile();
    }

    public void accept(Visitor v) {
        LoadbalancerVisitor lv = (LoadbalancerVisitor) v;
        lv.visit(this);
    }
}
