/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.admin.clbadmin.reader.impl;

import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.HealthChecker;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.util.i18n.StringManager;

import com.sun.logging.ee.EELogDomains;

import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.ClusterReader;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.InstanceReader;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.LbReaderException;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.WebModuleReader;
import org.jvnet.glassfish.comms.admin.clbadmin.transform.ClusterVisitor;
import org.jvnet.glassfish.comms.admin.clbadmin.transform.Visitor;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * Impl class for ClusterReader. This provides loadbalancer
 * data for a stand alone server (reverse proxy).
 *
 * @author Vijaya Gadhamsetty
 */
public class StandAloneClusterReaderImpl implements ClusterReader {
    private static final StringManager _strMgr = StringManager.getManager(StandAloneClusterReaderImpl.class);

    // ---- VARIABLE(S) - PRIVATE --------------------------
    private ConfigContext _configCtx = null;
    private ServerRef _serverRef = null;

    public StandAloneClusterReaderImpl(ConfigContext ctx, ServerRef ref)
        throws LbReaderException {
        if ((ctx == null) || (ref == null)) {
            String iMsg = _strMgr.getString("InvalidArgs");
            throw new RuntimeException(iMsg);
        }

        _configCtx = ctx;
        _serverRef = ref;

        try {
            if (!ServerHelper.isServerStandAlone(ctx, ref.getRef())) {
                String msg = _strMgr.getString("ServerNotFound", ref.getRef());
                throw new LbReaderException(msg);
            }
        } catch (ConfigException ce) {
            String msg = _strMgr.getString("ServerNotFound", ref.getRef());
            throw new LbReaderException(msg, ce);
        }
    }

    public String getName() {
        return _serverRef.getRef();
    }

    public String getSelfLoadbalance() {
        return null;
    }

    public InstanceReader[] getInstances() throws LbReaderException {
        InstanceReader[] readers = new InstanceReader[1];

        readers[0] = new InstanceReaderImpl(_configCtx, _serverRef);

        return readers;
    }

    public WebModuleReader[] getWebModules() throws LbReaderException {
        ApplicationRef[] refs = null;

        try {
            refs = ServerHelper.getApplicationReferences(_configCtx,
                    _serverRef.getRef());
        } catch (ConfigException ce) {
            String msg = _strMgr.getString("ErrorFindingClusteredApplications",
                    _serverRef.getRef());
            throw new LbReaderException(msg, ce);
        }

        return ClusterReaderHelper.getWebModules(_configCtx, refs,
            _serverRef.getRef());
    }

    public void accept(Visitor v) {
        ClusterVisitor cv = (ClusterVisitor) v;
        cv.visit(this);
    }
}
