/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.admin.clbadmin.transform;

import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.BaseReader;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.ClusterReader;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.LbReaderException;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.LoadbalancerReader;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.PropertyReader;
import org.jvnet.glassfish.comms.clb.admin.Cluster;
import org.jvnet.glassfish.comms.clb.admin.Loadbalancer;
import org.jvnet.glassfish.comms.clb.admin.Property;


/**
 * Provides transform capabilites for LB
 *
 * @author Vijaya Gadhamsetty
 */
public class LoadbalancerVisitor implements Visitor {
    private Loadbalancer _lb = null;

    public LoadbalancerVisitor(Loadbalancer lb) {
        _lb = lb;
    }

    /**
     * Visit reader class
     */
    public void visit(BaseReader br) {
        // FIXME, make as assert here about no class cast exception
        LoadbalancerReader lbRdr = (LoadbalancerReader) br;

        try {
            _lb.setHttpPolicy(lbRdr.getHttpPolicy());
            _lb.setSipPolicy(lbRdr.getSipPolicy());
            _lb.setDcrFile(lbRdr.getDcrFile());
        } catch (LbReaderException le) {
            // XXX ignore
        }

        Property prop = null;
        PropertyReader[] pRdrs = null;

        try {
            pRdrs = lbRdr.getProperties();
        } catch (LbReaderException le) {
            // should we throw this exception XXX ???
            // or fill in with default values
        }

        if ((pRdrs != null) && (pRdrs.length > 0)) {
            for (int i = 0; i < pRdrs.length; i++) {
                prop = new Property();
                pRdrs[i].accept(new PropertyVisitor(prop));
                _lb.getProperty().add(prop);
            }
        }

        ClusterReader[] cRdrs = null;

        try {
            cRdrs = lbRdr.getClusters();
        } catch (LbReaderException le) {
            // should we throw this exception XXX ???
            // or fill in with default values
        }

        if ((cRdrs != null) && (cRdrs.length > 0)) {
            for (int i = 0; i < cRdrs.length; i++) {
                Cluster cls = new Cluster();
                cRdrs[i].accept(new ClusterVisitor(cls));
                _lb.addCluster(cls);
            }
        }
    }
}
