/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package org.jvnet.glassfish.comms.admin.clbadmin.transform;

import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.BaseReader;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.LbReaderException;
import org.jvnet.glassfish.comms.admin.clbadmin.reader.api.PropertyReader;
import org.jvnet.glassfish.comms.clb.admin.Property;


/**
 * Provides transform capabilites for properties
 *
 * @author Vijaya Gadhamsetty
 */
public class PropertyVisitor implements Visitor {
    //--- PRIVATE VARS ----
    Property _prop = null;

    // ------ CTOR ------
    public PropertyVisitor(Property prop) {
        _prop = prop;
    }

    /**
     * Visit reader class
     */
    public void visit(BaseReader br) {
        // FIXME, make as assert here about no class cast exception
        PropertyReader pRdr = (PropertyReader) br;

        try {
            _prop.setName(pRdr.getName());
        } catch (LbReaderException le) {
            // XXX ignore
        }

        try {
            _prop.setValue(pRdr.getValue());
        } catch (LbReaderException le) {
            // XXX ignore
        }
    }
}
