/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.jvnet.glassfish.comms.admin.gui.extensions.handlers;

import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.jsftemplating.annotation.Handler;
import com.sun.jsftemplating.annotation.HandlerInput;
import com.sun.jsftemplating.annotation.HandlerOutput;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;

import org.jvnet.glassfish.comms.admin.gui.extensions.util.SipContainerHelper;
import org.jvnet.glassfish.comms.admin.gui.extensions.util.SipUtil;

/**
 *
 * @author irfan@sun.com
 */
public class SipContainerHandler {
    
    @Handler(id="getSipContainerGeneralProps",
    input={
        @HandlerInput(name="configName", type=String.class, required=true)
    },
    output={
        @HandlerOutput(name="properties", type=Map.class),
        @HandlerOutput(name="attrMap", type=Map.class)
    })
    public static void getSipContainerProps(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        HashMap attrMap = new HashMap();
        HashMap props = new HashMap();
        try {
            ObjectName sipContainer = SipContainerHelper.getSipContainerObject(configName);
            attrMap = SipContainerHelper.getContainerAttributes(sipContainer);
            props = SipUtil.getProperties(sipContainer);
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
        handlerContext.setOutputValue("properties", props);
        handlerContext.setOutputValue("attrMap", attrMap);
    }
    
    
    @Handler(id="saveSipContainerGeneralProps",
    input={
        @HandlerInput(name="configName", type=String.class, required=true),
        @HandlerInput(name="attrMap", type=Map.class),
        @HandlerInput(name="addProps", type=Map.class),
        @HandlerInput(name="removeProps", type=List.class)
    })
    public static void saveSipContainerGeneralProps(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        HashMap attrMap = (HashMap) handlerContext.getInputValue("attrMap");
        HashMap addProps = (HashMap) handlerContext.getInputValue("addProps");
        ArrayList removeProps = (ArrayList) handlerContext.getInputValue("removeProps");
        
        try {
            ObjectName sipContainer = SipContainerHelper.getSipContainerObject(configName);
            SipContainerHelper.saveContainerAttributes(sipContainer, attrMap);
            SipUtil.setProperties(sipContainer, addProps, removeProps);
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
    }
    
    @Handler(id="getSipSessionProps",
    input={
        @HandlerInput(name="configName", type=String.class, required=true)
    },
    output={
        @HandlerOutput(name="attrMap", type=Map.class),
        @HandlerOutput(name="properties", type=Map.class)
    })
    public static void getSipSessionProps(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        HashMap attrMap = new HashMap(0);
        HashMap props = new HashMap(0);
        try {
            ObjectName sessionObject = SipContainerHelper.getSessionPropertiesObject(configName);
            if (sessionObject != null) {
                attrMap = SipContainerHelper.getSessionPropertiesAttributes(sessionObject);
                props = SipUtil.getProperties(sessionObject);
            }
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
        handlerContext.setOutputValue("attrMap", attrMap);
        handlerContext.setOutputValue("properties", props);
    }
    
    @Handler(id="saveSipSessionProps",
    input={
        @HandlerInput(name="configName", type=String.class, required=true),
        @HandlerInput(name="attrMap", type=Map.class),
        @HandlerInput(name="addProps", type=Map.class),
        @HandlerInput(name="removeProps", type=List.class)
    })
    public static void saveSipSessionProps(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        HashMap attrMap = (HashMap) handlerContext.getInputValue("attrMap");
        HashMap addProps = (HashMap) handlerContext.getInputValue("addProps");
        ArrayList removeProps = (ArrayList) handlerContext.getInputValue("removeProps");
        
        try {
            ObjectName sessionObject = SipContainerHelper.getSessionPropertiesObject(configName);
            if (sessionObject == null) {
                //create session config
                ObjectName sessionConfig = SipUtil.createChildByFunction(SipContainerHelper.getSipContainerObject(configName),
                        "createSessionConfig");
                sessionObject = SipUtil.createChildByFunction(sessionConfig, "createSessionProperties");
            }
            SipContainerHelper.saveSessionPropertiesAttributes(sessionObject, attrMap);
            SipUtil.setProperties(sessionObject, addProps, removeProps);
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
    }
    
    @Handler(id="getSipManagerProps",
    input={
        @HandlerInput(name="configName", type=String.class, required=true)
    },
    output={
        @HandlerOutput(name="attrMap", type=Map.class),
        @HandlerOutput(name="properties", type=Map.class)
    })
    public static void getSipManagerProps(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        HashMap attrMap = new HashMap(0);
        HashMap props = new HashMap(0);
        try {
            ObjectName managerObject = SipContainerHelper.getManagerPropertiesObject(configName);
            if (managerObject != null) {
                attrMap = SipContainerHelper.getManagerPropertiesAttributes(managerObject);
                props = SipUtil.getProperties(managerObject);
            }
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
        handlerContext.setOutputValue("attrMap", attrMap);
        handlerContext.setOutputValue("properties", props);
    }
    
    @Handler(id="saveSipManagerProps",
    input={
        @HandlerInput(name="configName", type=String.class, required=true),
        @HandlerInput(name="attrMap", type=Map.class),
        @HandlerInput(name="addProps", type=Map.class),
        @HandlerInput(name="removeProps", type=List.class)
    })
    public static void saveSipManagerProps(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        HashMap attrMap = (HashMap) handlerContext.getInputValue("attrMap");
        HashMap addProps = (HashMap) handlerContext.getInputValue("addProps");
        ArrayList removeProps = (ArrayList) handlerContext.getInputValue("removeProps");
        
        try {
            ObjectName managerObject = SipContainerHelper.getManagerPropertiesObject(configName);
            if (managerObject == null) {
                //create manager-properties
                ObjectName parent = SipUtil.createChildByFunction(SipContainerHelper.getSipContainerObject(configName),
                        "createSessionConfig");
                //create session-manager
                parent = SipUtil.createChildByFunction(parent, "createSessionManager");
                managerObject = SipUtil.createChildByFunction(parent, "createManagerProperties");
            }
            SipContainerHelper.saveManagerPropertiesAttributes(managerObject, attrMap);
            SipUtil.setProperties(managerObject, addProps, removeProps);
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
    }
    
    @Handler(id="getSipStoreProps",
    input={
        @HandlerInput(name="configName", type=String.class, required=true)
    },
    output={
        @HandlerOutput(name="attrMap", type=Map.class),
        @HandlerOutput(name="properties", type=Map.class)
    })
    public static void getSipStoreProps(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        HashMap attrMap = new HashMap(0);
        HashMap props = new HashMap(0);
        try {
            ObjectName storeObject = SipContainerHelper.getStorePropertiesObject(configName);
            if (storeObject != null) {
                attrMap = SipContainerHelper.getStorePropertiesAttributes(storeObject);
                props = SipUtil.getProperties(storeObject);
            }
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
        handlerContext.setOutputValue("attrMap", attrMap);
        handlerContext.setOutputValue("properties", props);
    }
    
    @Handler(id="saveSipStoreProps",
    input={
        @HandlerInput(name="configName", type=String.class, required=true),
        @HandlerInput(name="attrMap", type=Map.class),
        @HandlerInput(name="addProps", type=Map.class),
        @HandlerInput(name="removeProps", type=List.class)
    })
    public static void saveSipStoreProps(HandlerContext handlerContext) {
        String configName = (String) handlerContext.getInputValue("configName");
        HashMap attrMap = (HashMap) handlerContext.getInputValue("attrMap");
        HashMap addProps = (HashMap) handlerContext.getInputValue("addProps");
        ArrayList removeProps = (ArrayList) handlerContext.getInputValue("removeProps");
        
        try {
            ObjectName storeObject = SipContainerHelper.getStorePropertiesObject(configName);
            if (storeObject == null) {
                //create manager-properties
                ObjectName parent = SipUtil.createChildByFunction(SipContainerHelper.getSipContainerObject(configName),
                        "createSessionConfig");
                //create session-manager
                parent = SipUtil.createChildByFunction(parent, "createSessionManager");
                storeObject = SipUtil.createChildByFunction(parent, "createStoreProperties");
            }
            SipContainerHelper.saveStorePropertiesAttributes(storeObject, attrMap);
            SipUtil.setProperties(storeObject, addProps, removeProps);
        } catch (Exception ex) {
            GuiUtil.handleException(handlerContext, ex);
        }
    }
}
